var tipuesearch = {"pages":[{"text":"Flex_extract: Calculation of etadot Developer Info Leopold Haimberger 1 1 Univ. of Vienna, Dept. of Meteorology & Geophysics","tags":"home","loc":"index.html","title":" Flex_extract: Calculation of etadot "},{"text":"This file depends on sourcefile~~calc_etadot.f90~~EfferentGraph sourcefile~calc_etadot.f90 calc_etadot.f90 sourcefile~rwgrib2.f90 rwgrib2.f90 sourcefile~calc_etadot.f90->sourcefile~rwgrib2.f90 sourcefile~ftrafo.f90 ftrafo.f90 sourcefile~calc_etadot.f90->sourcefile~ftrafo.f90 sourcefile~phgrreal.f90 phgrreal.f90 sourcefile~calc_etadot.f90->sourcefile~phgrreal.f90 sourcefile~grphreal.f90 grphreal.f90 sourcefile~calc_etadot.f90->sourcefile~grphreal.f90 sourcefile~ftrafo.f90->sourcefile~phgrreal.f90 sourcefile~grphreal.f90->sourcefile~phgrreal.f90 Help × Graph Key Nodes of different colours represent the following: Graph Key Source File Source File This Page's Entity This Page's Entity Solid arrows point from a file to a file which it depends on. A file\n    is dependent upon another if the latter must be compiled before the former\n    can be. Contents Programs calc_etadot Functions IA Subroutines STATIS Source Code calc_etadot.f90 Source Code PROGRAM calc_etadot !! Prepare input data for FLEXPART, esp. vertical velocity as !! etadot or etadot * dp/deta !*---------------------------------------------------------------- ! author: L. Haimberger ! date:   03/2010 ! version: V4.0 ! !## Program calc_etadot ! ! **Prepares input data for POP model meteorological preprocessor** ! !----------------------------------------------------------------- ! ! Calculation of etapoint on a regular \\lambda-\\phi grid and writing ! `U,V,ETAPOINT,T,PS,Q,SD,MSL,TCC,10U, 10V, 2T,2D,LSP,CP,SSHF,SSR, ! EWSS,NSSS` ! to an output file (input and output in GRIB 1 or 2 format). !  etapoint is defined as the total time derivative of !  ECMWF vertical coordinate eta multiplied by the derivative !  of pressure with respect to eta: !  \\frac{\\mathrm{d}\\eta}{\\mathrm{d}t}\\frac{\\partial p}{\\partial \\eta} ! !### Version history and authors: ! - 04/1994: Leopold Haimberger, Gerhard Wotawa ! ! - 2003-05-11: Alexander Beck ! ! - 12/2006: L. Haimberger V2.0, !           handle arbitrary regular grids and T799 resolution data ! ! - 03/2010: L. Haimberger V4.0, !           handle GRIB edition 2 fields and T1279 resolution data ! - 04-06/2019: Petra Seibert, !            beautify code and add FORD documentation ! - 06/2020: Petra Seibert, translate some comments into English !            comment out writing of VERTICAL.EC ! !----------------------------------------------------------------- ! !## Input required: ! !     UNIT  FILE      PARAMETER(S)    DATA REPRESENTATION ! !     11    fort.11   T,U,V           regular lat-lon grid !     12    fort.12   D               regular lat-lon grid !     13    fort.13   LNSP            spherical harmonics !     14    fort.14   SD,MSL,TCC,10U, !                     10V,2T,2D       regular lat-lon grid !     16    fort.16   LSP,CP,SSHF, !                     SSR,EWSS,NSSS   regular lat-lon grid !     17    fort.17   Q               regular lat-lon grid ! !------------------------------------------------------------------ ! !### Output produced: ! !    UNIT  FILE      PARAMETER(S)      DATA REPRESENTATION ! !    15    fort.15   `U,V,ETA,T,PS, !                    `Q,SD,MSL,TCC,` !                    `10U,10V,2T,2D,`  regular lat-lon grid !                    `LSP,CP,SSHF,` !                    `SSR,EWSS,NSSS` ! !------------------------------------------------------------------ ! Original version: ! Prepares input data for POP model meteorological preprocessor USE PHTOGR USE GRTOPH USE FTRAFO USE RWGRIB2 USE GRIB_API IMPLICIT NONE REAL , ALLOCATABLE , DIMENSION (:,:) :: LNPS REAL , ALLOCATABLE , DIMENSION (:,:) :: Z REAL , ALLOCATABLE , DIMENSION (:,:,:) :: T , UV , UV2 REAL , ALLOCATABLE , DIMENSION (:,:,:) :: QA , OM , OMR REAL , ALLOCATABLE , DIMENSION (:,:,:) :: DIV , ETA , ETAR REAL , ALLOCATABLE , DIMENSION (:,:) :: DPSDL , DPSDM REAL , ALLOCATABLE , DIMENSION (:,:,:) :: PS , DPSDT REAL , ALLOCATABLE , DIMENSION (:,:,:) :: SURF , FLUX , OROLSM REAL , ALLOCATABLE , DIMENSION (:) :: WSAVE , H , SINL , COSL , WSAVE2 REAL , ALLOCATABLE , DIMENSION (:) :: BREITE , GBREITE , AK , BK , pv ! Arrays for Gaussian grid calculations REAL :: X1 , X2 , RMS , MW , SIG , LAM REAL , ALLOCATABLE :: CUA (:,:,:), CVA (:,:,:) REAL , ALLOCATABLE , DIMENSION (:,:) :: P , PP , P2 REAL , ALLOCATABLE , DIMENSION (:,:) :: XMN , HILFUV REAL , ALLOCATABLE , DIMENSION (:) :: LNPMN , LNPMN2 , LNPMN3 REAL , ALLOCATABLE , DIMENSION (:) :: WEIGHT REAL , ALLOCATABLE , DIMENSION (:,:) :: UGVG REAL , ALLOCATABLE , DIMENSION (:,:) :: DG , ETAG REAL , ALLOCATABLE , DIMENSION (:,:) :: GWSAVE REAL , ALLOCATABLE , DIMENSION (:) :: PSG , HILF ! end arrays for Gaussian grid calculations INTEGER , ALLOCATABLE , DIMENSION (:) :: MLAT , MPSURF , MPFLUX , MPORO , MPAR INTEGER , ALLOCATABLE :: GIFAX (:,:) REAL PI , COSB , DAK , DBK , P00 REAL URLAR8 , JMIN1 , LLLAR8 , MAXBMIN1 , PIR8 , DCOSB INTEGER I , J , K , L , IERR , M , LTEST , MK , NGI , NGJ INTEGER MFLUX , MSURF , MORO INTEGER LUNIT , LUNIT2 INTEGER MAXL , MAXB , MLEVEL , LEVOUT , LEVMIN , LEVMAX INTEGER MOMEGA , MOMEGADIFF , MGAUSS , MSMOOTH , MNAUF , META , METADIFF INTEGER MDPDETA , METAPAR REAL RLO0 , RLO1 , RLA0 , RLA1 CHARACTER * 300 MLEVELIST INTEGER MAUF , MANF , IFAX ( 10 ) INTEGER IGRIB ( 1 ), iret , ogrib CHARACTER * 80 FILENAME NAMELIST / NAMGEN / & MAXL , MAXB , & MLEVEL , MLEVELIST , MNAUF , METAPAR , & RLO0 , RLO1 , RLA0 , RLA1 , & MOMEGA , MOMEGADIFF , MGAUSS , MSMOOTH , META , METADIFF ,& MDPDETA LTEST = 1 CALL POSNAM ( 4 , 'NAMGEN' ) READ ( 4 , NAMGEN ) MAUF = INT ( 36 0. * ( REAL ( MAXL ) - 1. ) / ( RLO1 - RLO0 ) + 0.0001 ) !      PRINT*, MAUF MANF = INT ( REAL ( MAUF ) / 36 0. * ( 36 0. + RLO0 ) + 1.0001 ) IF ( MANF . gt . MAUF ) MANF = MANF - MAUF !------------------------------------------------------------------ !! ALLOCATE VARIABLES !------------------------------------------------------------------ ALLOCATE ( LNPS ( 0 :( MNAUF + 1 ) * ( MNAUF + 2 ) - 1 , 1 )) ALLOCATE ( H ( 0 :( MNAUF + 2 ) * ( MNAUF + 3 ) / 2 )) ALLOCATE ( OM ( MAXL , MAXB , MLEVEL )) ALLOCATE ( ETA ( MAXL , MAXB , MLEVEL )) ALLOCATE ( PS ( MAXL , MAXB , 1 ), DPSDT ( MAXL , MAXB , 1 )) ALLOCATE ( WSAVE ( 4 * MAUF + 15 ), WSAVE2 ( 4 * MAUF + 15 )) ALLOCATE ( BREITE ( MAXB ), AK ( MLEVEL + 1 ), BK ( MLEVEL + 1 ), PV ( 2 * MLEVEL + 2 )) ALLOCATE ( MPAR ( 2 )) ALLOCATE ( COSL ( MAXL ), SINL ( MAXL )) ALLOCATE ( CUA ( 2 , 4 , MLEVEL ), CVA ( 2 , 4 , MLEVEL )) !------------------------------------------------------------------ ! GAUSS STUFF !------------------------------------------------------------------ IF ( MGAUSS . EQ . 1 ) THEN LUNIT = 0 FILENAME = 'fort.18' CALL GRIB_OPEN_FILE ( LUNIT , TRIM ( FILENAME ), 'R' ) CALL GRIB_NEW_FROM_FILE ( LUNIT , IGRIB ( 1 ), IRET ) ! we can close the file CALL GRIB_CLOSE_FILE ( LUNIT ) !      call grib_get(igrib(1),'gridType', j) NGJ = MNAUF + 1 ALLOCATE ( GWSAVE ( 8 * NGJ + 15 , NGJ / 2 )) ALLOCATE ( GIFAX ( 10 , NGJ )) ALLOCATE ( GBREITE ( NGJ ), WEIGHT ( NGJ )) ALLOCATE ( MLAT ( NGJ )) ALLOCATE ( P ( 0 :(( MNAUF + 3 ) * ( MNAUF + 4 )) / 2 , NGJ / 2 )) ALLOCATE ( PP ( NGJ / 2 , 0 :(( MNAUF + 3 ) * ( MNAUF + 4 )) / 2 )) ALLOCATE ( Z ( 0 :(( MNAUF + 3 ) * ( MNAUF + 4 )) / 2 , MAXB )) CALL GRIB_GET ( IGRIB ( 1 ), 'numberOfPointsAlongAMeridian' , NGJ ) !   get as a integer call grib_get ( igrib ( 1 ), 'pl' , MLAT ) NGI = SUM ( MLAT ) CALL GRIB_GET ( IGRIB ( 1 ), 'numberOfVerticalCoordinateValues' , MK ) IF ( MK / 2 - 1 . NE . MLEVEL ) THEN WRITE ( * , * ) 'FATAL: Number of model levels' , mk , & ' does not agree with' , MLEVEL , ' in namelist' STOP END IF call grib_get ( igrib ( 1 ), 'pv' , pv ) AK = PV ( 1 : 1 + MLEVEL ) BK = PV ( 2 + MLEVEL : 2 * MLEVEL + 2 ) ALLOCATE ( LNPMN ( 0 :( MNAUF + 1 ) * ( MNAUF + 2 ) - 1 )) ALLOCATE ( LNPMN2 ( 0 :( MNAUF + 1 ) * ( MNAUF + 2 ) - 1 )) ALLOCATE ( UGVG ( NGI , 2 * MLEVEL ), HILFUV ( 2 * MAXL , 2 )) ALLOCATE ( DPSDL ( NGI , 1 ), DPSDM ( NGI , 1 )) ALLOCATE ( PSG ( NGI ), HILF ( NGI )) ALLOCATE ( UV ( MAXL , MAXB , 2 * MLEVEL )) !      ALLOCATE (UV2(MAXL, MAXB, 2*MLEVEL)) ALLOCATE ( XMN ( 0 :( MNAUF + 1 ) * ( MNAUF + 2 ) - 1 , 2 * MLEVEL )) ALLOCATE ( DG ( NGI , MLEVEL ), ETAG ( NGI , MLEVEL )) !! Initialise  Legendre transformation on the lat-lon grid PI = ACOS ( - 1.D0 ) !$OMP PARALLEL DO DO 20 J = 1 , MAXB BREITE ( J ) = SIN (( RLA1 - ( J - 1.D0 ) * ( RLA1 - RLA0 ) / ( MAXB - 1 )) * PI / 18 0.D0 ) CALL PLGNFA ( MNAUF , BREITE ( J ), Z ( 0 , J )) 20 CONTINUE !$OMP END PARALLEL DO ! Avoid possible Pole problem !      IF (RLA0 .EQ. -90.0) BREITE(MAXB)=sin(-89.99*PI/180.d0) !      IF (RLA1 .EQ. 90.0)  BREITE(1)=sin(89.99*PI/180.d0) !* Initialisation of fields for FFT and Legendre transformation ! to Gaussian grid and back to phase space X1 =- 1.D0 X2 = 1.D0 CALL GAULEG ( X1 , X2 , GBREITE , WEIGHT , NGJ ) !$OMP PARALLEL DO PRIVATE(M) DO J = 1 , NGJ / 2 CALL PLGNFA ( MNAUF , GBREITE ( J ), P (:, J )) DO M = 0 ,( MNAUF + 3 ) * ( MNAUF + 4 ) / 2 PP ( J , M ) = P ( M , J ) END DO END DO !$OMP END PARALLEL DO !       MPAR(1)=152 FILENAME = 'fort.12' !!  read LNSP in SH CALL READSPECTRAL ( FILENAME , LNPMN , MNAUF , 1 , MLEVEL ,( / 152 / ), AK , BK ) CALL SET99 ( WSAVE , IFAX , mauf ) CALL PHGCUT ( LNPMN , PS , WSAVE , IFAX , Z , MNAUF , MNAUF , MAUF , MANF , MAXL , MAXB , 1 ) CALL STATIS ( MAXL , MAXB , 1 , EXP ( PS ), RMS , MW , SIG ) WRITE ( * , '(A,T20,3F12.4)' ) 'STATISTICS PS: ' , RMS , MW , SIG DO J = 1 , NGJ / 2 CALL SET99 ( GWSAVE ( 1 , J ), GIFAX ( 1 , J ), MLAT ( J )) END DO CALL PHGR213 ( LNPMN , HILF , GWSAVE , GIFAX , P , MLAT , MNAUF , NGI , NGJ , 1 ) PSG = HILF CALL GRPH213 ( LNPMN2 , PSG , GWSAVE , GIFAX , PP , WEIGHT , MLAT , MNAUF , NGI , NGJ , 1 ) CALL PHGR213 ( LNPMN2 , HILF , GWSAVE , GIFAX , P , MLAT , MNAUF , NGI , NGJ , 1 ) HILF = exp ( PSG ) - exp ( HILF ) CALL STATIS ( NGI , 1 , 1 , HILF , RMS , MW , SIG ) WRITE ( * , '(A,T20,3F12.4)' ) 'STATISTICS ratio of PS: ' , RMS , MW , SIG PSG = EXP ( PSG ) HILF = PSG CALL STATIS ( NGI , 1 , 1 , HILF , RMS , MW , SIG ) WRITE ( * , '(A,T20,3F12.4)' ) 'STATISTICS PSG: ' , RMS , MW , SIG 111 FILENAME = 'fort.10' !!  read u,v in SH CALL READSPECTRAL ( FILENAME , XMN , MNAUF , 2 * MLEVEL , MLEVEL ,( / 131 , 132 / ), AK , BK ) !!  Transforming the wind to the Gaussian grid CALL PHGR213 ( XMN , UGVG , GWSAVE , GIFAX , P , MLAT , MNAUF , NGI , NGJ , 2 * MLEVEL ) DO K = 1 , MLEVEL ! North Pole CALL JSPPOLE ( XMN (:, K ), 1 , MNAUF ,. TRUE ., CUA (:,:, K )) CALL JSPPOLE ( XMN (:, MLEVEL + K ), 1 , MNAUF ,. TRUE ., CVA (:,:, K )) ! South Pole CALL JSPPOLE ( XMN (:, K ), - 1 , MNAUF ,. TRUE ., CUA (:, 3 : 4 , K )) CALL JSPPOLE ( XMN (:, MLEVEL + K ), - 1 , MNAUF ,. TRUE ., CVA (:, 3 : 4 , K )) END DO DO K = 1 , 2 * MLEVEL IF ( MSMOOTH . ne . 0 ) CALL SPFILTER ( XMN (:, K ), MNAUF , MSMOOTH ) END DO CALL PHGCUT ( XMN , UV , WSAVE , IFAX , Z , MNAUF , MNAUF , MAUF , MANF , MAXL , MAXB , 2 * MLEVEL ) 112 FILENAME = 'fort.13' !!  read DIV in SH CALL READSPECTRAL ( FILENAME , XMN , MNAUF , MLEVEL , MLEVEL ,( / 155 / ), AK , BK ) !! Transform horizontal divergence to the Gaussian grid CALL PHGR213 ( XMN , DG , GWSAVE , GIFAX , P , MLAT , MNAUF , NGI , NGJ , MLEVEL ) CALL STATIS ( MAXL , MAXB , 1 , DG , RMS , MW , SIG ) WRITE ( * , '(A,T20,3p,3F12.4)' ) 'STATISTICS DG-PS: ' , RMS , MW , SIG !! Calculation of the gradient of LNSP (log of surface pressure) on Gaussian grid CALL PHGRAD ( LNPMN , DPSDL , DPSDM , GWSAVE , GIFAX , P , H , MLAT , MNAUF , NGI , NGJ , 1 ) !! Calculation of the vertical velocity on the Gaussian grid CALL CONTGL ( HILF , DPSDL , DPSDM , DG , UGVG (:, 1 ), UGVG (:, MLEVEL + 1 ), & GBREITE , ETAG , MLAT , AK , BK , NGI , NGJ , MLEVEL ) ! note that HILF is ps on input and  dpsdt*ps on output CALL STATIS ( MAXL , MAXB , 1 , ETAG , RMS , MW , SIG ) WRITE ( * , '(A,T20,3p,3F12.4)' ) 'STATISTICS ETAG-PS: ' , RMS , MW , SIG CALL GRPH213 ( XMN , ETAG , GWSAVE , GIFAX , PP , WEIGHT , MLAT , MNAUF , NGI , NGJ , MLEVEL ) CALL STATIS ( MAXL , MAXB , 1 , ETAG , RMS , MW , SIG ) WRITE ( * , '(A,T20,3p,3F12.4)' ) 'STATISTICS ETAG-PS: ' , RMS , MW , SIG DO K = 1 , MLEVEL IF ( MSMOOTH . ne . 0 ) CALL SPFILTER ( XMN (:, K ), MNAUF , MSMOOTH ) END DO CALL PHGCUT ( XMN , ETA , WSAVE , IFAX , Z , MNAUF , MNAUF , MAUF , MANF , MAXL , MAXB , MLEVEL ) CALL STATIS ( MAXL , MAXB , 1 , ETA , RMS , MW , SIG ) WRITE ( * , '(A,T20,3p,3F12.4)' ) 'STATISTICS ETA-PS: ' , RMS , MW , SIG CALL GRPH213 ( XMN , HILF , GWSAVE , GIFAX , PP , WEIGHT , MLAT , MNAUF , NGI , NGJ , 1 ) CALL STATIS ( MAXL , MAXB , 1 , HILF , RMS , MW , SIG ) WRITE ( * , '(A,T20,3p,3F12.4)' ) 'STATISTICS HILF-PS: ' , RMS , MW , SIG IF ( MSMOOTH . ne . 0 ) CALL SPFILTER ( XMN (:, 1 ), MNAUF , MSMOOTH ) CALL PHGCUT ( XMN , DPSDT , WSAVE , IFAX , Z , MNAUF , MNAUF , MAUF , MANF , MAXL , MAXB , 1 ) CALL STATIS ( MAXL , MAXB , 1 , DPSDT , RMS , MW , SIG ) WRITE ( * , '(A,T20,3F12.4)' ) 'STATISTICS DPSDT: ' , RMS , MW , SIG IF ( MOMEGADIFF . ne . 0 ) THEN !! Calculation of omega on the Gaussian grid CALL OMEGA ( PSG , DPSDL , DPSDM , DG , UGVG (:, 1 ), UGVG (:, MLEVEL + 1 ), & GBREITE , ETAG , MLAT , AK , BK , NGI , NGJ , MLEVEL ) CALL GRPH213 ( XMN , ETAG , GWSAVE , GIFAX , PP , WEIGHT , MLAT , MNAUF , NGI , NGJ , MLEVEL ) DO K = 1 , MLEVEL IF ( MSMOOTH . ne . 0 ) CALL SPFILTER ( XMN (:, K ), MNAUF , MSMOOTH ) END DO CALL PHGCUT ( XMN , OM , WSAVE , IFAX , Z , MNAUF , MNAUF , MAUF , MANF , MAXL , MAXB , MLEVEL ) END IF ! MOMEGA CALL GRPH213 ( XMN , PSG , GWSAVE , GIFAX , PP , WEIGHT , MLAT , MNAUF , NGI , NGJ , 1 ) CALL STATIS ( MAXL , MAXB , 1 , PSG , RMS , MW , SIG ) WRITE ( * , '(A,T20,3F12.4)' ) 'STATISTICS PSG-PS: ' , RMS , MW , SIG CALL PHGCUT ( XMN , PS , WSAVE , IFAX , Z , MNAUF , MNAUF , MAUF , MANF , MAXL , MAXB , 1 ) CALL STATIS ( MAXL , MAXB , 1 , PS , RMS , MW , SIG ) WRITE ( * , '(A,T20,3F12.4)' ) 'STATISTICS PS: ' , RMS , MW , SIG 114 DEALLOCATE ( HILF , PSG , DPSDL , DPSDM , ETAG , DG , LNPMN ) !      ALLOCATE (UV(MAXL, MAXB, 2*MLEVEL)) ! CALL GRPH213(XMN,UGVG,GWSAVE,GIFAX,PP,WEIGHT,MLAT, !     *MNAUF,NGI,NGJ,2*MLEVEL) !        DO K=1,2*MLEVEL !          IF (MSMOOTH .ne. 0) CALL SPFILTER(XMN(:,K),MNAUF,MSMOOTH) !        END DO !        CALL PHGCUT(XMN,UV,WSAVE,IFAX,Z, !     *MNAUF,MNAUF,MAUF,MANF,MAXL,MAXB,2*MLEVEL) DEALLOCATE ( PP , P , UGVG , MLAT , GBREITE , WEIGHT , GWSAVE , XMN ) !        CALL ETAGAUSS(Z,WSAVE !     *,BREITE,UV,ETA,OM,PS, !     *MAUF,MAXB,MAXL,MANF,MNAUF,MLEVEL,MSMOOTH) ELSE !----------------------------------------------------------------- !     READING OF PREPARED METEOROLOGICAL FIELDS ! !     THE FOLLOWING FIELDS ARE EXPECTED: ! !     UNIT 11: T,U,V        (REGULAR GRID) !     UNIT 17: Q            (REGULAR GRID) !     UNIT 13: D            (REGULAR GRID) !     UNIT 12: LNSP         (SPHERICAL HARMONICS) !     UNIT 14: SURFACE DATA (REGULAR GRID) !     UNIT 16: FLUX DATA    (REGULAR GRID) !------------------------------------------------------------------ ALLOCATE ( MLAT ( MAXB )) MLAT = MAXL ALLOCATE ( Z ( 0 :(( MNAUF + 3 ) * ( MNAUF + 4 )) / 2 , 1 )) ALLOCATE ( DPSDL ( MAXL , MAXB ), DPSDM ( MAXL , MAXB )) ALLOCATE ( UV ( MAXL , MAXB , 2 * MLEVEL ), DIV ( MAXL , MAXB , MLEVEL )) !------------------------------------------------------------------ !! READING OF SURFACE PRESSURE !------------------------------------------------------------------ FILENAME = 'fort.12' CALL READSPECTRAL ( FILENAME , LNPS , MNAUF , 1 , MLEVEL ,( / 152 / ), AK , BK ) !------------------------------------------------------------------ !! READING OF U,V !------------------------------------------------------------------ ! OPENING OF UNBLOCKED GRIB FILE FILENAME = 'fort.10' CALL READLATLON ( FILENAME , UV , MAXL , MAXB , 2 * MLEVEL ,( / 131 , 132 / )) PI = ACOS ( - 1.D0 ) DO J = 1 , MAXB BREITE ( J ) = SIN (( RLA1 - ( J - 1.D0 ) * ( RLA1 - RLA0 ) / ( MAXB - 1 )) * PI / 18 0.D0 ) END DO ! Avoid possible Pole problem !      IF (RLA0 .EQ. -90.0) BREITE(MAXB)=sin(-89.99*PI/180.d0) !      IF (RLA1 .EQ. 90.0)  BREITE(1)=sin(89.99*PI/180.d0) DO K = 1 , 2 * MLEVEL DO J = 1 , MAXB COSB = SQRT ( 1.0 - ( BREITE ( J )) * ( BREITE ( J ))) IF ( RLA0 . EQ . - 9 0.0 . AND . J . EQ . MAXB . OR . & RLA1 . EQ . 9 0.0 . AND . J . EQ . 1 ) THEN UV (:, J , K ) = UV (:, J , K ) / 1.D6 ELSE UV (:, J , K ) = UV (:, J , K ) * COSB END IF END DO END DO !------------------------------------------------------------------ !! READING OF LNSP on grid !------------------------------------------------------------------ ! For debugging only !      FILENAME='LNSPG_G.20060330.600' !      INQUIRE(FILE=FILENAME,EXIST=EX) !      CALL READLATLON(FILENAME,QA, !     *MAXL,MAXB,1,1,(/152/)) !------------------------------------------------------------------ !! READING OF DIVERGENCE !------------------------------------------------------------------ IF ( META . EQ . 0 . OR . METADIFF . EQ . 1 ) THEN FILENAME = 'fort.13' CALL READLATLON ( FILENAME , DIV , MAXL , MAXB , MLEVEL ,( / 155 / )) END IF !------------------------------------------------------------------ ! !  Calculation of etapoint --> total time derivative of !  ECMWF vertical coordinate eta multiplied by the derivative !  of pressure with respect to eta: !  \\frac{\\mathrm{d}\\eta}{\\mathrm{d}t}\\frac{\\partial p}{\\partial \\eta} !------------------------------------------------------------------ !------------------------------------------------------------------ !* Initialise Legendre transformation on the lat-lon grid. !! Without Gaussian grid calculation, !! Legendre polynomials are calculated only for one latitude, to save space DO J = 1 , MAXB CALL PLGNFA ( MNAUF , BREITE ( J ), Z ( 0 , 1 )) CALL PHGCUT ( LNPS , PS (:, J , 1 ), WSAVE , IFAX , Z , MNAUF , MNAUF , MAUF , MANF , MAXL , 1 , 1 ) IF ( META . EQ . 0 . OR . METADIFF . EQ . 1 ) THEN CALL PHGRACUT ( LNPS , DPSDL (:, J ), DPSDM (:, J ), WSAVE , IFAX , Z , H , MAUF , & MNAUF , MAXL , 1 , MANF , 1 ) END IF END DO PS = EXP ( PS ) ! For debugging only CALL STATIS ( MAXL , MAXB , 1 , PS (:,:, 1 ), RMS , MW , SIG ) WRITE ( * , '(A,T20,3F12.4)' ) 'STATISTICS: ' , RMS , MW , SIG IF ( MOMEGADIFF . ne . 0 ) THEN CALL OMEGA ( PS , DPSDL , DPSDM , DIV , UV (:,:, 1 ), UV (:,:, MLEVEL + 1 ), & BREITE , OM , MLAT , AK , BK , MAXL * MAXB , MAXB , MLEVEL ) END IF IF ( META . EQ . 0 . OR . METADIFF . ne . 0 ) THEN DPSDT = PS CALL CONTGL ( DPSDT , DPSDL , DPSDM , DIV , UV (:,:, 1 ), UV (:,:, MLEVEL + 1 ), & BREITE , ETA , MLAT , AK , BK , MAXL * MAXB , MAXB , MLEVEL ) END IF END IF ! MGAUSS ! CREATE FILE VERTICAL.EC NEEDED BY POP MODEL ! 2020-06-25 Commented out by PS - not needed anymore !  OPEN(21,FILE='VERTICAL.EC') !  WRITE(21,'(A)') !  WRITE(21,'(A)') 'VERTICAL DISCRETIZATION OF POP MODEL' !  WRITE(21,'(A)') !  write(21,'(i3,a)') MLEVEL,'   number of layers' !  WRITE(21,'(A)') !  WRITE(21,'(A)') '* A(NLEV+1)' !  WRITE(21,'(A)') !  DO 205 I=1,MLEVEL+1 !205 WRITE(21,'(F18.12)') AK(I) !  WRITE(21,'(A)') !  WRITE(21,'(A)') '* B(NLEV+1)' !  WRITE(21,'(A)') !  DO 210 I=1,MLEVEL+1 !210 WRITE(21,'(F18.12)') BK(I) !  CLOSE(21) !------------------------------------------------------------------ ! READING OF OMEGA !------------------------------------------------------------------ IF ( MOMEGA . NE . 0 ) THEN ALLOCATE ( OMR ( MAXL , MAXB , MLEVEL )) FILENAME = 'fort.19' CALL READLATLON ( FILENAME , OMR , MAXL , MAXB , MLEVEL ,( / 135 / )) IF ( MOMEGADIFF . NE . 0 ) THEN DO K = 1 , MLEVEL CALL STATIS ( MAXL , MAXB , 1 , ETA (:,:, K ), RMS , MW , SIG ) WRITE ( * , '(A12,I3,3F12.4)' ) '       ETA: ' , K , RMS , MW , SIG CALL STATIS ( MAXL , MAXB , 1 , OMR (:,:, K ), RMS , MW , SIG ) WRITE ( * , '(A12,I3,3F12.4)' ) '     OMEGA: ' , K , RMS , MW , SIG CALL STATIS ( MAXL , MAXB , 1 , OM (:,:, K ) - OMR (:,:, K ), RMS , MW , SIG ) WRITE ( * , '(A12,I3,3F12.4)' ) 'OMEGA DIFF: ' , K , RMS , MW , SIG END DO END IF END IF !------------------------------------------------------------------ ! READING OF ETA !------------------------------------------------------------------ IF ( META . NE . 0 ) THEN ALLOCATE ( ETAR ( MAXL , MAXB , MLEVEL )) P00 = 10132 5. FILENAME = 'fort.21' CALL READLATLON ( FILENAME , ETAR , MAXL , MAXB , MLEVEL ,( / 77 / )) IF ( MDPDETA . EQ . 1 ) THEN DO K = 1 , MLEVEL DAK = AK ( K + 1 ) - AK ( K ) DBK = BK ( K + 1 ) - BK ( K ) DO J = 1 , MAXB DO I = 1 , MAXL ETAR ( I , J , K ) = 2 * ETAR ( I , J , K ) * PS ( I , J , 1 ) * ( DAK / PS ( I , J , 1 ) + DBK ) / & ( DAK / P00 + DBK ) IF ( K . GT . 1 ) ETAR ( I , J , K ) = ETAR ( I , J , K ) - ETAR ( I , J , K - 1 ) END DO END DO END DO END IF IF ( METADIFF . NE . 0 ) THEN DO K = 1 , MLEVEL CALL STATIS ( MAXL , MAXB , 1 , ETA (:,:, K ), RMS , MW , SIG ) WRITE ( * , '(A12,I3,3F12.4)' ) '       ETA: ' , K , RMS , MW , SIG CALL STATIS ( MAXL , MAXB , 1 , ETAR (:,:, K ), RMS , MW , SIG ) WRITE ( * , '(A12,I3,3F12.4)' ) '     ETAR: ' , K , RMS , MW , SIG CALL STATIS ( MAXL , MAXB , 1 , ETA (:,:, K ) - ETAR (:,:, K ), RMS , MW , SIG ) WRITE ( * , '(A12,I3,3F12.4)' ) 'ETA DIFF: ' , K , RMS , MW , SIG END DO DO K = 1 , MLEVEL WRITE ( * , '(I3,2F12.4)' ) K , ETA ( 1 , MAXB / 2 , K ), ETAR ( 1 , MAXB / 2 , K ) END DO ELSE ETA = ETAR END IF END IF ALLOCATE ( T ( MAXL , MAXB , MLEVEL )) ALLOCATE ( QA ( MAXL , MAXB , MLEVEL )) !------------------------------------------------------------------ !! READING OF T !------------------------------------------------------------------ ! OPENING OF UNBLOCKED GRIB FILE FILENAME = 'fort.11' CALL READLATLON ( FILENAME , T , MAXL , MAXB , MLEVEL ,( / 130 / )) !------------------------------------------------------------------ !! READING OF SPECIFIC HUMIDITY !------------------------------------------------------------------ FILENAME = 'fort.17' CALL READLATLON ( FILENAME , QA , MAXL , MAXB , MLEVEL ,( / 133 / )) !------------------------------------------------------------------ !                     TEST READING OF UV from MARS (debug only) !------------------------------------------------------------------ !      FILENAME='fort.22' !      CALL READLATLON(FILENAME,UV2,MAXL,MAXB,2*MLEVEL,2,(/131,132/)) !------------------------------------------------------------------ !! WRITE MODEL LEVEL DATA TO fort.15 !------------------------------------------------------------------ !     Calculation of etadot in CONTGL needed scaled winds (ucosphi,vcosphi) !     Now we are transforming back to the usual winds. DO K = 1 , MLEVEL DO J = 2 , MAXB - 1 COSB = SQRT ( 1.0 - ( BREITE ( J )) * ( BREITE ( J ))) UV (:, J , K ) = UV (:, J , K ) / COSB UV (:, J , MLEVEL + K ) = UV (:, J , MLEVEL + K ) / COSB END DO ! special treatment for poles, if necessary. DO J = 1 , MAXB , MAXB - 1 COSB = SQRT ( 1.0 - ( BREITE ( J )) * ( BREITE ( J ))) IF ( 1.0 - BREITE ( J ) * BREITE ( J ) . GT . 0 . OR . MGAUSS . NE . 1 ) THEN IF ( RLA0 . EQ . - 9 0.0 . AND . J . EQ . MAXB . OR . & RLA1 . EQ . 9 0.0 . AND . J . EQ . 1 ) THEN UV (:, J , K ) = UV (:, J , K ) * 1.D6 UV (:, J , MLEVEL + K ) = UV (:, J , MLEVEL + K ) * 1.D6 ELSE UV (:, J , K ) = UV (:, J , K ) / COSB UV (:, J , MLEVEL + K ) = UV (:, J , MLEVEL + K ) / COSB END IF ELSE HILFUV ( 5 : MAXL ,:) = 0. HILFUV ( 1 : 2 ,:) = 0. IF ( J . EQ . MAXB ) THEN ! Suedpol HILFUV ( 3 : 4 , 1 ) = CUA (:, 4 , K ) HILFUV ( 3 : 4 , 2 ) = CVA (:, 4 , K ) ELSE ! Nordpol HILFUV ( 3 : 4 , 1 ) = CUA (:, 2 , K ) HILFUV ( 3 : 4 , 2 ) = CVA (:, 2 , K ) END IF CALL RFOURTR ( HILFUV (:, 1 ), WSAVE , IFAX , MAXL / 2 - 1 , MAXL , - 1 ) DO I = 0 , MAXL - 1 IF ( MANF + I . LE . MAXL ) THEN UV ( I + 1 , J , K ) = HILFUV ( MANF + I , 1 ) ELSE UV ( I + 1 , J , K ) = HILFUV ( MANF - MAXL + I , 1 ) END IF END DO CALL RFOURTR ( HILFUV (:, 2 ), WSAVE , IFAX , MAXL / 2 - 1 , MAXL , - 1 ) DO I = 0 , MAXL - 1 IF ( MANF + I . LE . MAXL ) THEN UV ( I + 1 , J , MLEVEL + K ) = HILFUV ( MANF + I , 2 ) ELSE UV ( I + 1 , J , MLEVEL + K ) = HILFUV ( MANF - MAXL + I , 2 ) END IF END DO end if END DO END DO ! open output file call grib_open_file ( LUNIT , 'fort.15' , 'w' ) ! we use temperature on lat/lon on model levels as template for model level data LUNIT2 = 0 CALL GRIB_OPEN_FILE ( LUNIT2 , 'fort.11' , 'R' ) CALL GRIB_NEW_FROM_FILE ( LUNIT2 , IGRIB ( 1 ), IRET ) CALL GRIB_CLOSE_FILE ( LUNIT2 ) CALL WRITELATLON & ( LUNIT , IGRIB ( 1 ), OGRIB , UV (:,:, 1 ), MAXL , MAXB , MLEVEL , MLEVELIST , 1 ,( / 131 / )) CALL WRITELATLON & ( LUNIT , IGRIB ( 1 ), OGRIB , UV (:,:, MLEVEL + 1 ), MAXL , MAXB , MLEVEL , MLEVELIST , 1 ,( / 132 / )) IF ( MDPDETA . ne . 1 . AND . MGAUSS . EQ . 0 . and . META . eq . 1 ) THEN CALL WRITELATLON & ( LUNIT , IGRIB ( 1 ), OGRIB , ETA , MAXL , MAXB , MLEVEL , MLEVELIST , 1 ,( / 77 / )) ELSE CALL WRITELATLON & ( LUNIT , IGRIB ( 1 ), OGRIB , ETA , MAXL , MAXB , MLEVEL , MLEVELIST , 1 ,( / METAPAR / )) END IF CALL WRITELATLON ( LUNIT , IGRIB ( 1 ), OGRIB , T , MAXL , MAXB , MLEVEL , MLEVELIST , 1 ,( / 130 / )) CALL WRITELATLON ( LUNIT , IGRIB ( 1 ), OGRIB , PS , MAXL , MAXB , 1 , '1' , 1 ,( / 134 / )) CALL GRIB_SET ( IGRIB ( 1 ), \"levelType\" , \"ml\" ) CALL GRIB_SET ( IGRIB ( 1 ), \"typeOfLevel\" , \"hybrid\" ) CALL WRITELATLON ( LUNIT , IGRIB ( 1 ), OGRIB , QA , MAXL , MAXB , MLEVEL , MLEVELIST , 1 ,( / 133 / )) IF ( MOMEGA . EQ . 1 ) THEN CALL GRIB_OPEN_FILE ( LUNIT2 , 'fort.25' , 'w' ) CALL WRITELATLON & ( LUNIT2 , IGRIB ( 1 ), OGRIB , OMR , MAXL , MAXB , MLEVEL , MLEVELIST , 1 ,( / 135 / )) IF ( MOMEGADIFF . EQ . 1 ) THEN CALL WRITELATLON ( LUNIT2 , IGRIB ( 1 ), OGRIB , DPSDT , MAXL , MAXB , 1 , '1' , 1 ,( / 158 / )) OM = OM - OMR CALL WRITELATLON & ( LUNIT2 , IGRIB ( 1 ), OGRIB , OM , MAXL , MAXB , MLEVEL , MLEVELIST , 1 ,( / 001 / )) CALL GRIB_CLOSE_FILE ( LUNIT2 ) END IF END IF IF ( META . EQ . 1 . AND . METADIFF . EQ . 1 ) THEN CALL GRIB_OPEN_FILE ( LUNIT2 , 'fort.26' , 'w' ) CALL WRITELATLON & ( LUNIT2 , IGRIB ( 1 ), OGRIB , ETAR , MAXL , MAXB , MLEVEL , MLEVELIST , 1 ,( / 135 / )) !        IF (MOMEGADIFF .EQ. 1) THEN CALL WRITELATLON ( LUNIT2 , IGRIB ( 1 ), OGRIB , DPSDT , MAXL , MAXB , 1 , '1' , 1 ,( / 158 / )) OM = ETA - ETAR CALL WRITELATLON & ( LUNIT2 , IGRIB ( 1 ), OGRIB , OM , MAXL , MAXB , MLEVEL , MLEVELIST , 1 ,( / 001 / )) CALL GRIB_CLOSE_FILE ( LUNIT2 ) !        END IF END IF CALL GRIB_CLOSE_FILE ( LUNIT ) 2000 STOP 'SUCCESSFULLY FINISHED calc_etadot: CONGRATULATIONS' 3000 STOP 'ROUTINE calc_etadot: ERROR' 9999 stop 'ROUTINE calc_etadot: ERROR' END !------------------------------------------------------------------ INTEGER FUNCTION IA ( FIELD1 , NI , NJ , NK , G ) !------------------------------------------------------------------ !! Calculate something that is roughly log10( maxval(field1)/g ) [PS] !------------------------------------------------------------------ IMPLICIT NONE INTEGER :: I , J , K INTEGER , INTENT ( IN ) :: NI , NJ , NK REAL , INTENT ( IN ) :: FIELD1 ( NI , NJ , NK ) REAL , INTENT ( IN ) :: G REAL :: RMIN , RMAX , XMAX , A , A1 , A2 RMAX = FIELD1 ( 1 , 1 , 1 ) RMIN = FIELD1 ( 1 , 1 , 1 ) DO 100 K = 1 , NK DO 100 J = 1 , NJ DO 100 I = 1 , NI IF ( FIELD1 ( I , J , K ) . GT . RMAX ) RMAX = FIELD1 ( I , J , K ) IF ( FIELD1 ( I , J , K ) . LT . RMIN ) RMIN = FIELD1 ( I , J , K ) 100 CONTINUE IF ( ABS ( RMIN ) . GT . RMAX . OR . ABS ( RMIN ) . EQ . RMAX ) THEN XMAX = ABS ( RMIN ) ELSE XMAX = RMAX END IF IF ( XMAX . EQ . 0 ) THEN IA = 0 RETURN END IF A1 = LOG10 ( ( G / 1 0.d0 ) / XMAX ) A2 = LOG10 ( G / XMAX ) IF ( A1 . gt . A2 ) THEN A = A2 ELSE A = A1 END IF IF ( A . GT . 0 ) IA = INT ( A ) IF ( A . LT . 0 ) IA = INT ( A - 1.0 ) RETURN END SUBROUTINE STATIS ( NI , NJ , NK , PHI , RMS , MW , SIG ) !------------------------------------------------------------------ !! calculate mean, rms, stdev !------------------------------------------------------------------ IMPLICIT REAL ( A - H , O - Z ) REAL PHI ( NI , NJ , NK ), SIG , MW , RMS , P N = NI * NJ * NK RMS = 0. MW = 0. ! 10.86 sinstead of 11.04 sec DO 10 K = 1 , NK DO 10 J = 1 , NJ DO 10 I = 1 , NI P = PHI ( I , J , K ) RMS = RMS + P * P MW = MW + P 10 CONTINUE RMS = SQRT ( RMS / N ) MW = MW / N IF ( RMS * RMS - MW * MW . LT . 0. ) THEN SIG = 0.0 ELSE SIG = SQRT ( RMS * RMS - MW * MW ) END IF RETURN END","tags":"","loc":"sourcefile/calc_etadot.f90.html","title":"calc_etadot.f90 – Flex_extract: Calculation of etadot"},{"text":"Files dependent on this one sourcefile~~rwgrib2.f90~~AfferentGraph sourcefile~rwgrib2.f90 rwgrib2.f90 sourcefile~calc_etadot.f90 calc_etadot.f90 sourcefile~calc_etadot.f90->sourcefile~rwgrib2.f90 Help × Graph Key Nodes of different colours represent the following: Graph Key Source File Source File This Page's Entity This Page's Entity Solid arrows point from a file to a file which it depends on. A file\n    is dependent upon another if the latter must be compiled before the former\n    can be. Contents Modules RWGRIB2 Source Code rwgrib2.f90 Source Code MODULE RWGRIB2 !! Read or write a field variable on a lat/lon grid from/to GRIB file, or !! read a field in spectral representation from GRIB file CONTAINS SUBROUTINE READLATLON ( FILENAME , FELD , MAXL , MAXB , MLEVEL , MPAR ) !! Read a field from GRIB file on lat-lon grid USE GRIB_API IMPLICIT NONE integer :: ifile integer :: iret integer :: n , mk , parid , nm integer :: i , k integer , dimension (:), allocatable :: igrib integer :: numberOfPointsAlongAParallel integer :: numberOfPointsAlongAMeridian real , dimension (:), allocatable :: values integer :: numberOfValues real , dimension ( maxl , maxb , mlevel ) :: feld integer :: maxl , maxb , mlevel , mstride , mpar (:), irest , div , level integer :: l ( size ( mpar )) character * ( * ) :: filename feld = 0. call grib_open_file ( ifile , TRIM ( FILENAME ), 'r' ) ! count the messages in the file call grib_count_in_file ( ifile , n ) allocate ( igrib ( n )) igrib =- 1 ! Load the messages from the file. DO i = 1 , n call grib_new_from_file ( ifile , igrib ( i ), iret ) END DO ! we can close the file call grib_close_file ( ifile ) nm = size ( mpar ) div = mlevel / nm l = 0 ! Loop on all the messages in memory iloop : DO i = 1 , n !      write(*,*) 'processing message number ',i !     get as a integer call grib_get ( igrib ( i ), 'numberOfPointsAlongAParallel' , & numberOfPointsAlongAParallel ) !     get as a integer call grib_get ( igrib ( i ), 'numberOfPointsAlongAMeridian' , & numberOfPointsAlongAMeridian ) call grib_get ( igrib ( i ), 'numberOfVerticalCoordinateValues' , mk ) call grib_get_size ( igrib ( i ), 'values' , numberOfValues ) !      write(*,*) 'numberOfValues=',numberOfValues allocate ( values ( numberOfValues ), stat = iret ) !     get data values call grib_get ( igrib ( i ), 'values' , values ) call grib_get ( igrib ( i ), 'paramId' , parid ) call grib_get ( igrib ( i ), 'level' , level ) kloop : do k = 1 , nm if ( parid . eq . mpar ( k )) then !         l(k)=l(k)+1 feld (:,:,( k - 1 ) * div + level ) = reshape ( values ,( / maxl , maxb / )) !         print*,(k-1)*div+l(k),parid exit kloop end if end do kloop if ( k . gt . nm . and . parid . ne . mpar ( nm )) then write ( * , * ) k , nm , parid , mpar ( nm ) write ( * , * ) 'ERROR readlatlon: parameter ' , parid , 'is not' , mpar stop end if !      print*,i END DO iloop ! !   write(*,*) 'readlatlon: ',i-1,' records read' DO i = 1 , n call grib_release ( igrib ( i )) END DO if ( allocated ( values )) deallocate ( values ) deallocate ( igrib ) END SUBROUTINE READLATLON SUBROUTINE WRITELATLON ( iunit , igrib , ogrib , FELD , MAXL , MAXB , MLEVEL ,& MLEVELIST , MSTRIDE , MPAR ) !! write a field on lat-lon grid to GRIB file USE GRIB_API IMPLICIT NONE INTEGER IFIELD , MLEVEL , MNAUF , I , J , K , L , MSTRIDE , IERR , JOUT INTEGER MPAR ( MSTRIDE ), MAXL , MAXB , LEVMIN , LEVMAX INTEGER IUNIT , igrib , ogrib REAL ZSEC4 ( MAXL * MAXB ) REAL FELD ( MAXL , MAXB , MLEVEL ) CHARACTER * ( * ) MLEVELIST INTEGER ILEVEL ( MLEVEL ), MLINDEX ( MLEVEL + 1 ), LLEN ! parse MLEVELIST LLEN = len ( trim ( MLEVELIST )) if ( index ( MLEVELIST , 'to' ) . ne . 0 . or . index ( MLEVELIST , 'TO' ) . ne . 0 ) THEN i = index ( MLEVELIST , '/' ) read ( MLEVELIST ( 1 : i - 1 ), * ) LEVMIN i = index ( MLEVELIST , '/' ,. true .) read ( MLEVELIST ( i + 1 : LLEN ), * ) LEVMAX l = 0 do i = LEVMIN , LEVMAX l = l + 1 ILEVEL ( l ) = i end do else l = 1 MLINDEX ( 1 ) = 0 do i = 1 , LLEN if ( MLEVELIST ( i : i ) . eq . '/' ) THEN l = l + 1 MLINDEX ( l ) = i end if end do MLINDEX ( l + 1 ) = LLEN + 1 do i = 1 , l read ( MLEVELIST ( MLINDEX ( i ) + 1 : MLINDEX ( i + 1 ) - 1 ), * ) ILEVEL ( i ) end do end if DO k = 1 , l call grib_set ( igrib , \"level\" , ILEVEL ( k )) DO j = 1 , MSTRIDE call grib_set ( igrib , \"paramId\" , MPAR ( j )) !         if (MPAR(j) .eq. 87) then !           call grib_set(igrib,\"shortName\",\"etadot\") !           call grib_set(igrib,\"units\",\"Pa,s**-1\") !         end if !         if (MPAR(j) .eq. 77) then !           call grib_set(igrib,\"shortName\",\"etadot\") !           call grib_set(igrib,\"units\",\"s**-1\") !         end if if ( l . ne . mlevel ) then zsec4 ( 1 : maxl * maxb ) = RESHAPE ( FELD (:,:, ILEVEL ( k )),( / maxl * maxb / )) else zsec4 ( 1 : maxl * maxb ) = RESHAPE ( FELD (:,:, k ),( / maxl * maxb / )) end if call grib_set ( igrib , \"values\" , zsec4 ) call grib_write ( igrib , iunit ) END DO END DO END SUBROUTINE WRITELATLON SUBROUTINE READSPECTRAL ( FILENAME , CXMN , MNAUF , MLEVEL , MAXLEV , MPAR , A , B ) !!  Read a GRIB file in spherical harmonics USE GRIB_API IMPLICIT NONE integer :: ifile integer :: iret integer :: n , mk , div , nm , k integer :: i , j , parid integer , dimension (:), allocatable :: igrib real , dimension (:), allocatable :: values integer :: numberOfValues , maxlev REAL :: A ( MAXLEV + 1 ), B ( MAXLEV + 1 ), pv ( 2 * MAXLEV + 2 ) REAL :: CXMN ( 0 :( MNAUF + 1 ) * ( MNAUF + 2 ) - 1 , MLEVEL ) integer :: maxl , maxb , mlevel , mstride , mpar (:), mnauf , ioffset , ipar , ilev , l ( size ( mpar )) character * ( * ) :: filename call grib_open_file ( ifile , TRIM ( FILENAME ), 'r' ) ! count the messages in the file call grib_count_in_file ( ifile , n ) allocate ( igrib ( n )) igrib =- 1 ! Load the messages from the file. DO i = 1 , n call grib_new_from_file ( ifile , igrib ( i ), iret ) END DO ! we can close the file call grib_close_file ( ifile ) l = 0 ! Loop on all the messages in memory iloop : DO i = 1 , n ! write(*,*) 'processing message number ',i !     get as a integer call grib_get ( igrib ( i ), 'pentagonalResolutionParameterJ' , j ) call grib_get_size ( igrib ( i ), 'values' , numberOfValues ) !   write(*,*) 'numberOfValues=',numberOfValues call grib_get ( igrib ( i ), 'numberOfVerticalCoordinateValues' , mk ) call grib_get ( igrib ( i ), 'level' , ilev ) call grib_get ( igrib ( i ), 'pv' , pv ) allocate ( values ( numberOfValues ), stat = iret ) !     get data values call grib_get ( igrib ( i ), 'values' , values ) !      IOFFSET=mod(i-1,MSTRIDE)*(mk/2-1) !           CXMN(:,IOFFSET+ilev)=values(1:(MNAUF+1)*(MNAUF+2)) call grib_get ( igrib ( i ), 'paramId' , parid ) nm = size ( mpar ) div = mlevel / nm kloop : do k = 1 , nm if ( parid . eq . mpar ( k )) then l ( k ) = l ( k ) + 1 cxmn (:,( k - 1 ) * div + l ( k )) = values ( 1 :( MNAUF + 1 ) * ( MNAUF + 2 )) !         print*,(k-1)*div+l(k),parid exit kloop end if end do kloop if ( k . gt . nm . and . parid . ne . mpar ( nm )) then write ( * , * ) k , nm , parid , mpar ( nm ) write ( * , * ) 'ERROR readspectral: parameter ' , parid , 'is not' , mpar stop end if !      print*,i END DO iloop ! !   write(*,*) 'readspectral: ',i-1,' records read' DO i = 1 , n call grib_release ( igrib ( i )) END DO deallocate ( values ) deallocate ( igrib ) A = pv ( 1 : 1 + MAXLEV ) B = pv ( 2 + MAXLEV : 2 * MAXLEV + 2 ) END SUBROUTINE READSPECTRAL END MODULE RWGRIB2","tags":"","loc":"sourcefile/rwgrib2.f90.html","title":"rwgrib2.f90 – Flex_extract: Calculation of etadot"},{"text":"This file depends on sourcefile~~grphreal.f90~~EfferentGraph sourcefile~grphreal.f90 grphreal.f90 sourcefile~phgrreal.f90 phgrreal.f90 sourcefile~grphreal.f90->sourcefile~phgrreal.f90 Help × Graph Key Nodes of different colours represent the following: Graph Key Source File Source File This Page's Entity This Page's Entity Solid arrows point from a file to a file which it depends on. A file\n    is dependent upon another if the latter must be compiled before the former\n    can be. Files dependent on this one sourcefile~~grphreal.f90~~AfferentGraph sourcefile~grphreal.f90 grphreal.f90 sourcefile~calc_etadot.f90 calc_etadot.f90 sourcefile~calc_etadot.f90->sourcefile~grphreal.f90 Help × Graph Key Nodes of different colours represent the following: Graph Key Source File Source File This Page's Entity This Page's Entity Solid arrows point from a file to a file which it depends on. A file\n    is dependent upon another if the latter must be compiled before the former\n    can be. Contents Modules GRTOPH Source Code grphreal.f90 Source Code MODULE GRTOPH !! Module for transformation from phase space into physical space USE PHTOGR CONTAINS SUBROUTINE GRPH213 ( CXMN , FELD , WSAVE , IFAX , Z , W , MLAT , MNAUF , MAXL , MAXB , MLEVEL ) ! WRONG>>> DIE ROUTINE F]HRT EINE TRANSFORMATION EINER ! FELDVARIABLEN VOM PHASENRAUM IN  DEN PHYSIKALISCHEN ! RAUM AUF KUGELKOORDINATEN DURCH ! CXMN   = SPEKTRALKOEFFIZIENTEN IN DER REIHENFOLGE !          CX00,CX01,CX11,CX02,....CXMNAUFMNAUF ! CXM   = FOURIERKOEFFIZIENTEN - nur ein Hilfsfeld ! FELD   = FELD DER METEOROLOGISCHEN VARIABLEN ! WSAVE  = Working Array fuer Fouriertransformation ! Z   = LEGENDREFUNKTIONSWERTE ! ! MNAUF    ANZAHL DER FOURIERKOEFFIZIENTEN ! MAXL     ANZAHL DER FUER DAS GITTER BENUTZTEN LAENGEN ! MAXB     ANZAHL DER FUER DAS GITTER BENOETIGTEN BREITEN ! MLEVEL   ANZAHL DER LEVELS, DIE TRANSFORMIERT WERDEN IMPLICIT REAL ( A - H , O - Z ) !   Anzahl der Gitterpunkte pro Breitenkreis des reduzierten !   Gauss'schen Gitters INTEGER MLAT ( MAXB ), ISIZE , IFAX ( 10 , MAXB ) !   FELD DER LEGENDREPOLYNOME FUER EINE BREITE REAL Z ( MAXB / 2 , 0 :(( MNAUF + 3 ) * ( MNAUF + 4 )) / 2 ) !   LOGICAL*1 USED(((216*217)/2+1)*160) DIMENSION CXMN ( 0 :( MNAUF + 1 ) * ( MNAUF + 2 ) - 1 , MLEVEL ) REAL FELD ( MAXL , MLEVEL ) DIMENSION WSAVE ( 8 * MAXB + 15 , MAXB / 2 ) REAL W ( MAXB ) DIMENSION IND ( MAXB ) IND ( 1 ) = 0 DO 6 J = 2 , MAXB / 2 IND ( j ) = IND ( J - 1 ) + MLAT ( J - 1 ) 6 CONTINUE !$OMP PARALLEL DO SCHEDULE(DYNAMIC) DO 16 L = 1 , MLEVEL CALL GRPHSUB ( L , IND , CXMN , FELD , WSAVE , IFAX , Z , W , MLAT , MNAUF , MAXL , MAXB , MLEVEL ) 16 CONTINUE !$omp end parallel do RETURN END SUBROUTINE GRPH213 SUBROUTINE GRPHSUB ( L , IND , CXMN , FELD , WSAVE , IFAX , Z , W , MLAT , MNAUF , MAXL , MAXB , MLEVEL ) !! Carries out the transformation from the phase space into the physical !! space on spherical coordinates ! CXMN  = SPEKTRALKOEFFIZIENTEN IN DER REIHENFOLGE !         CX00,CX01,CX11,CX02,....CXMNAUFMNAUF ! CXM   = FOURIERKOEFFIZIENTEN - nur ein Hilfsfeld ! FELD  = FELD DER METEOROLOGISCHEN VARIABLEN ! WSAVE = Working Array fuer Fouriertransformation ! Z     = LEGENDREFUNKTIONSWERTE ! ! MNAUF ANZAHL DER FOURIERKOEFFIZIENTEN ! MAXL  ANZAHL DER FUER DAS GITTER BENUTZTEN LAENGEN ! MAXB  ANZAHL DER FUER DAS GITTER BENOETIGTEN BREITEN ! MLEVEL ANZAHL DER LEVELS, DIE TRANSFORMIERT WERDEN IMPLICIT REAL ( A - H , O - Z ) !   FELD DER FOURIERKOEFFIZIENTEN REAL CXMS ( 4 * ( MNAUF + 1 )) REAL CXMA ( 4 * ( MNAUF + 1 )) REAL , ALLOCATABLE :: CXM (:,:) !   Anzahl der Gitterpunkte pro Breitenkreis des reduzierten !   Gauss'schen Gitters INTEGER MLAT ( MAXB ), ISIZE !   FELD DER LEGENDREPOLYNOME FUER EINE BREITE REAL Z ( MAXB / 2 , 0 :(( MNAUF + 3 ) * ( MNAUF + 4 )) / 2 ) !   LOGICAL*1 USED(((216*217)/2+1)*160) REAL CXMN ( 0 :( MNAUF + 1 ) * ( MNAUF + 2 ) - 1 , MLEVEL ) REAL FELD ( MAXL , MLEVEL ) REAL WSAVE ( 8 * MAXB + 15 , MAXB / 2 ) INTEGER IFAX ( 10 , MAXB ) REAL W ( MAXB ) INTEGER IND ( MAXB ) ALLOCATE ( CXM ( 4 * MAXB , MAXB )) DO 5 J = 1 , MAXB / 2 CXMS ( 1 : MLAT ( J )) = FELD ( IND ( J ) + 1 : IND ( J ) + MLAT ( J ), L ) CALL RFOUFTR ( CXMS , WSAVE ( 1 , J ), IFAX (:, J ), MNAUF , MLAT ( J ), 1 ) CXMA ( 1 : MLAT ( J )) = FELD ( MAXL - IND ( J ) - MLAT ( J ) + 1 : MAXL - IND ( J ), L ) CALL RFOUFTR ( CXMA , WSAVE ( 1 , J ), IFAX (:, J ), MNAUF , MLAT ( J ), 1 ) DO 4 I = 1 , 2 * ( MNAUF + 1 ) CXM ( I , J ) = CXMS ( I ) + CXMA ( I ) CXM ( I , MAXB + 1 - J ) = CXMS ( I ) - CXMA ( I ) 4 CONTINUE 5 CONTINUE CALL LGTR213 ( CXMN ( 0 , L ), CXM , Z , W , MLAT , MNAUF , MAXB ) DEALLOCATE ( CXM ) RETURN END SUBROUTINE GRPHSUB ! SUBROUTINE LGTR213 ( CXMN , CXM , Z , W , MLAT , MNAUF , MAXB ) !! Calculates the KFFKs (Fourier coefficients) CXMN IMPLICIT REAL ( A - H , O - Z ) INTEGER MLAT ( MAXB ) DIMENSION CXM ( 0 : 4 * MAXB - 1 , MAXB ) DIMENSION CXMN ( 0 : 2 * ((( MNAUF + 1 ) * MNAUF ) / 2 + MNAUF ) + 1 ) REAL * 8 Z ( MAXB / 2 , 0 :(( MNAUF + 3 ) * ( MNAUF + 4 )) / 2 ) REAL * 8 W ( MAXB ), CR , CI , HILF LOGICAL EVEN LL = 0 LLP = 0 DO 1 I = 0 , MNAUF KM = 0 9 KM = KM + 1 IF ( MLAT ( KM ) . LE . 2 * I ) THEN GOTO 9 END IF DO 2 J = I , MNAUF CR = 0 CI = 0 EVEN = MOD ( I + J , 2 ) . EQ . 0 IF ( EVEN ) THEN DO 3 K = KM , MAXB / 2 HILF = W ( K ) * Z ( K , LLP ) CR = CR + CXM ( 2 * I , K ) * HILF CI = CI + CXM ( 2 * I + 1 , K ) * HILF 3 CONTINUE ELSE DO 4 K = KM , MAXB / 2 HILF = W ( K ) * Z ( K , LLP ) CR = CR + CXM ( 2 * I , MAXB + 1 - K ) * HILF CI = CI + CXM ( 2 * I + 1 , MAXB + 1 - K ) * HILF 4 CONTINUE END IF 5 CXMN ( 2 * LL ) = CR CXMN ( 2 * LL + 1 ) = CI LL = LL + 1 LLP = LLP + 1 2 CONTINUE LLP = LLP + 2 1 CONTINUE RETURN END SUBROUTINE LGTR213 SUBROUTINE RFOUFTR ( CXM , TRIGS , IFAX , MNAUF , MAXL , ISIGN ) !! Calculates the Fourier sum with an FFT algorithm IMPLICIT REAL ( A - H , O - Z ) DIMENSION CXM ( 0 : 2 * MAXL - 1 ) DIMENSION FELD ( MAXL ), TRIGS ( 2 * MAXL ) DIMENSION WSAVE ( MAXAUF ) INTEGER IFAX ( 10 ) ! NORMIERUNG... WSAVE ( 1 ) = CXM ( MAXL - 1 ) CXM ( 1 : MAXL ) = CXM ( 0 : MAXL - 1 ) / 2 CXM ( 0 ) = WSAVE ( 1 ) / 2 !    CALL CFFTF(MAXL,CXM,WSAVE) CALL FFT99 ( CXM , WSAVE , TRIGS , IFAX , 1 , 1 , MAXL , 1 , - 1 ) RETURN END SUBROUTINE RFOUFTR END MODULE GRTOPH","tags":"","loc":"sourcefile/grphreal.f90.html","title":"grphreal.f90 – Flex_extract: Calculation of etadot"},{"text":"Files dependent on this one sourcefile~~phgrreal.f90~~AfferentGraph sourcefile~phgrreal.f90 phgrreal.f90 sourcefile~calc_etadot.f90 calc_etadot.f90 sourcefile~calc_etadot.f90->sourcefile~phgrreal.f90 sourcefile~ftrafo.f90 ftrafo.f90 sourcefile~calc_etadot.f90->sourcefile~ftrafo.f90 sourcefile~grphreal.f90 grphreal.f90 sourcefile~calc_etadot.f90->sourcefile~grphreal.f90 sourcefile~ftrafo.f90->sourcefile~phgrreal.f90 sourcefile~grphreal.f90->sourcefile~phgrreal.f90 Help × Graph Key Nodes of different colours represent the following: Graph Key Source File Source File This Page's Entity This Page's Entity Solid arrows point from a file to a file which it depends on. A file\n    is dependent upon another if the latter must be compiled before the former\n    can be. Contents Modules PHTOGR Source Code phgrreal.f90 Source Code MODULE PHTOGR !! Module for transformation of a field variable from the phase space !! into the physical space onto the reduced Gaussian grid INTEGER , PARAMETER :: MAXAUF = 36000 CONTAINS SUBROUTINE PHGR213 ( CXMN , FELD , WSAVE , IFAX , Z , MLAT , MNAUF , MAXL , MAXB , MLEVEL ) ! DIE ROUTINE F]HRT EINE TRANSFORMATION EINER ! FELDVARIABLEN VOM PHASENRAUM IN  DEN PHYSIKALISCHEN ! RAUM AUF DAS REDUZIERTE GAUSS'SCHE GITTER DURCH ! ! CXMN   = SPEKTRALKOEFFIZIENTEN IN DER REIHENFOLGE !          CX00,CX01,CX11,CX02,....CXMNAUFMNAUF ! FELD   = FELD DER METEOROLOGISCHEN VARIABLEN ! WSAVE  = Working Array fuer Fouriertransformation ! Z      = LEGENDREFUNKTIONSWERTE ! ! MNAUF  ANZAHL DER FOURIERKOEFFIZIENTEN ! MAXL   ANZAHL DER FUER DAS GITTER BENUTZTEN LAENGEN ! MAXB   ANZAHL DER FUER DAS GITTER BENOETIGTEN BREITEN ! MLEVEL ANZAHL DER LEVELS, DIE TRANSFORMIERT WERDEN IMPLICIT NONE !   Anzahl der Gitterpunkte auf jedem Breitenkreis INTEGER MLAT ( MAXB / 2 ) INTEGER K , MAXL , MAXB , MLEVEL , MNAUF INTEGER IND ( MAXB ) !   FELD DER LEGENDREPOLYNOME FUER EINE BREITE REAL Z ( 0 :(( MNAUF + 3 ) * ( MNAUF + 4 )) / 2 , MAXB / 2 ) REAL CXMN ( 0 :( MNAUF + 1 ) * ( MNAUF + 2 ) - 1 , MLEVEL ) REAL FELD ( MAXL , MLEVEL ) REAL WSAVE ( 8 * MAXB + 15 , MAXB / 2 ) INTEGER :: IFAX ( 10 , MAXB ) IND ( 1 ) = 0 DO 7 K = 2 , MAXB / 2 IND ( K ) = IND ( K - 1 ) + MLAT ( K - 1 ) 7 CONTINUE !$OMP PARALLEL DO SCHEDULE(DYNAMIC) DO 17 K = 1 , MAXB / 2 CALL PHSYM ( K , IND , CXMN , FELD , Z , WSAVE , IFAX , MLAT , MNAUF , MAXL , MAXB , MLEVEL ) 17 CONTINUE !$OMP END PARALLEL DO RETURN END SUBROUTINE PHGR213 SUBROUTINE PHSYM ( K , IND , CXMN , FELD , Z , WSAVE , IFAX , MLAT , MNAUF , MAXL , MAXB , MLEVEL ) IMPLICIT NONE INTEGER MLAT ( MAXB / 2 ) INTEGER K , L , I , J , LLS , LLPS , LL , LLP , MAXL , MAXB , MLEVEL , MNAUF INTEGER IND ( MAXB ) INTEGER :: IFAX ( 10 , MAXB ) !   FELD DER FOURIERKOEFFIZIENTEN REAL :: CXMS ( 0 : MAXAUF - 1 ), CXMA ( 0 : MAXAUF - 1 ) !   FELD DER LEGENDREPOLYNOME FUER EINE BREITE REAL Z ( 0 :(( MNAUF + 3 ) * ( MNAUF + 4 )) / 2 , MAXB / 2 ) REAL ACR , ACI , SCR , SCI REAL CXMN ( 0 :( MNAUF + 1 ) * ( MNAUF + 2 ) - 1 , MLEVEL ) REAL FELD ( MAXL , MLEVEL ) REAL WSAVE ( 8 * MAXB + 15 , MAXB / 2 ) DO 6 L = 1 , MLEVEL LL = 0 LLP = 0 DO 1 I = 0 , MNAUF SCR = 0.D0 SCI = 0.D0 ACR = 0.D0 ACI = 0.D0 LLS = LL LLPS = LLP IF ( 2 * I + 1 . LT . MLAT ( K )) THEN !         Innerste Schleife aufgespalten um if-Abfrage zu sparen DO 18 J = I , MNAUF , 2 SCR = SCR + Z ( LLP , K ) * CXMN ( 2 * LL , L ) SCI = SCI + Z ( LLP , K ) * CXMN ( 2 * LL + 1 , L ) LL = LL + 2 LLP = LLP + 2 18 CONTINUE LL = LLS + 1 LLP = LLPS + 1 DO 19 J = I + 1 , MNAUF , 2 ACR = ACR + Z ( LLP , K ) * CXMN ( 2 * LL , L ) ACI = ACI + Z ( LLP , K ) * CXMN ( 2 * LL + 1 , L ) LL = LL + 2 LLP = LLP + 2 19 CONTINUE END IF LL = LLS + ( MNAUF - I + 1 ) LLP = LLPS + ( MNAUF - I + 3 ) CXMS ( 2 * I ) = SCR + ACR CXMS ( 2 * I + 1 ) = SCI + ACI CXMA ( 2 * I ) = SCR - ACR CXMA ( 2 * I + 1 ) = SCI - ACI 1 CONTINUE !     CALL FOURTR(CXMS,FELD(IND(k)+1,L),WSAVE(:,K),MNAUF,*MLAT(K),1) !     CALL FOURTR(CXMA,FELD(MAXL-IND(k)-MLAT(K)+1,L),WSAVE(:,K),MNAUF,MLAT(K),1) CALL RFOURTR ( CXMS , WSAVE (:, K ), IFAX (:, K ), MNAUF , MLAT ( K ), 1 ) FELD ( IND ( k ) + 1 : IND ( K ) + MLAT ( K ), L ) = CXMS ( 0 : MLAT ( K ) - 1 ) CALL RFOURTR ( CXMA , WSAVE (:, K ), IFAX (:, K ), MNAUF , MLAT ( K ), 1 ) FELD ( MAXL - IND ( k ) - MLAT ( K ) + 1 : MAXL - IND ( k ), L ) = CXMA ( 0 : MLAT ( K ) - 1 ) !      WRITE(*,*) IND+1,FELD(IND+1,L) 6 CONTINUE END SUBROUTINE PHSYM SUBROUTINE PHGCUT ( CXMN , FELD , WSAVE , IFAX , Z , & MNAUF , MMAX , MAUF , MANF , MAXL , MAXB , MLEVEL ) !! Carries out the transformation of a field variable from the phase space !! into the physical space on spherical coordinates. It is possible to !! specify a section of the Earth. This subroutine is slower thatn PHGRPH. ! CXMN   = SPEKTRALKOEFFIZIENTEN IN DER REIHENFOLGE !          CX00,CX01,CX11,CX02,....CXMNAUFMNAUF ! FELD   = FELD DER METEOROLOGISCHEN VARIABLEN ! BREITE = SINUS DER GEOGRAFISCHEN BREITEN ! ! MNAUF  ANZAHL DER FOURIERKOEFFIZIENTEN ! MAUF   ANZAHL DER LAENGEN UND DER FOURIERKOEFFIZIENTEN ! MANF   ANFANG DES LAENGENBEREICHS FUER DAS GITTER, !        AUF DAS INTERPOLIERT WERDEN SOLL ! MAXL   ANZAHL DER FUER DAS GITTER BENUTZTEN LAENGEN ! MAXB   ANZAHL DER FUER DAS GITTER BENOETIGTEN BREITEN ! MLEVEL ANZAHL DER LEVELS, DIE TRANSFORMIERT WERDEN IMPLICIT REAL ( A - H , O - Z ) !   FELD DER FOURIERKOEFFIZIENTEN !   FELD DER LEGENDREPOLYNOME FUER EINE BREITE REAL Z ( 0 :(( MMAX + 3 ) * ( MMAX + 4 )) / 2 , MAXB ) DIMENSION CXMN ( 0 :( MMAX + 1 ) * ( MMAX + 2 ) - 1 , MLEVEL ) REAL FELD ( MAXL , MAXB , MLEVEL ) DIMENSION WSAVE ( 4 * MAUF + 15 ) INTEGER :: IFAX ( 10 ) LOGICAL SYM !    write(*,*)mauf,mnauf,manf,maxl IF ( MAUF . LE . MNAUF ) WRITE ( * , * ) 'TOO COARSE LONGITUDE RESOLUTION' IF ( MANF . LT . 1 . OR . MAXL . LT . 1 . OR . & MANF . GT . MAUF . OR . MAXL . GT . MAUF ) THEN WRITE ( * , * ) 'WRONG LONGITUDE RANGE' , MANF , MAXL STOP END IF ! Pruefe, ob Ausgabegitter symmetrisch zum Aequator ist ! Wenn ja soll Symmetrie der Legendrepolynome ausgenutzt werden IF ( MAXB . GT . 4 ) THEN SYM = . TRUE . DO 11 J = 5 , 5 IF ( ABS ( ABS ( Z ( 100 , J )) - ABS ( Z ( 100 , MAXB + 1 - J ))) . GT . 1E-11 ) SYM = . FALSE . !       WRITE(*,*) ABS(Z(100,J)),ABS(Z(100,MAXB+1-J)) 11 CONTINUE ! !      WRITE(*,*) 'Symmetrisch: ',SYM ELSE SYM = . FALSE . END IF IF ( SYM ) THEN !$OMP PARALLEL DO DO J = 1 ,( MAXB + 1 ) / 2 CALL PHSYMCUT ( J , CXMN , FELD , Z , WSAVE , IFAX , MAUF , MNAUF , MAXL , MAXB , MLEVEL , MANF ) END DO !$OMP END PARALLEL DO ELSE !$OMP PARALLEL DO DO J = 1 , MAXB CALL PHGPNS ( CXMN , FELD , Z , WSAVE , IFAX , J , MNAUF , MAUF , MANF , MAXL , MAXB , MLEVEL ) END DO !$OMP END PARALLEL DO END IF RETURN END SUBROUTINE PHGCUT SUBROUTINE PHSYMCUT ( J , CXMN , FELD , Z , WSAVE , IFAX , MAUF , MNAUF , MAXL , MAXB , MLEVEL , MANF ) IMPLICIT REAL ( A - H , O - Z ) !   FELD DER FOURIERKOEFFIZIENTEN REAL :: CXM ( 0 : MAXAUF - 1 ), CXMA ( 0 : MAXAUF - 1 ) !   FELD DER LEGENDREPOLYNOME FUER EINE BREITE REAL Z ( 0 :(( MNAUF + 3 ) * ( MNAUF + 4 )) / 2 , MAXB ) REAL SCR , SCI , ACR , ACI DIMENSION CXMN ( 0 :( MNAUF + 1 ) * ( MNAUF + 2 ) - 1 , MLEVEL ) REAL FELD ( MAXL , MAXB , MLEVEL ) DIMENSION WSAVE ( 4 * MAUF + 15 ) INTEGER :: IFAX ( 10 ) DO 16 L = 1 , MLEVEL LL = 0 LLP = 0 DO 17 I = 0 , MNAUF SCR = 0.D0 SCI = 0.D0 ACR = 0.D0 ACI = 0.D0 LLS = LL LLPS = LLP !       Innerste Schleife aufgespalten um if-Abfrage zu sparen DO 18 K = I , MNAUF , 2 SCR = SCR + Z ( LLP , J ) * CXMN ( 2 * LL , L ) SCI = SCI + Z ( LLP , J ) * CXMN ( 2 * LL + 1 , L ) LL = LL + 2 LLP = LLP + 2 18 CONTINUE LL = LLS + 1 LLP = LLPS + 1 DO 19 K = I + 1 , MNAUF , 2 ACR = ACR + Z ( LLP , J ) * CXMN ( 2 * LL , L ) ACI = ACI + Z ( LLP , J ) * CXMN ( 2 * LL + 1 , L ) LL = LL + 2 LLP = LLP + 2 19 CONTINUE LL = LLS + MNAUF - I + 1 LLP = LLPS + MNAUF - I + 3 CXM ( 2 * I ) = SCR + ACR CXM ( 2 * I + 1 ) = SCI + ACI CXMA ( 2 * I ) = SCR - ACR CXMA ( 2 * I + 1 ) = SCI - ACI 17 CONTINUE CALL RFOURTR ( CXM , WSAVE , IFAX , MNAUF , MAUF , 1 ) DO 26 I = 0 , MAXL - 1 IF ( MANF + I . LE . MAUF ) THEN FELD ( I + 1 , J , L ) = CXM ( MANF + I - 1 ) ELSE FELD ( I + 1 , J , L ) = CXM ( MANF - MAUF + I - 1 ) END IF 26 CONTINUE CALL RFOURTR ( CXMA , WSAVE , IFAX , MNAUF , MAUF , 1 ) DO 36 I = 0 , MAXL - 1 IF ( MANF + I . LE . MAUF ) THEN FELD ( I + 1 , MAXB + 1 - J , L ) = CXMA ( MANF + I - 1 ) ELSE FELD ( I + 1 , MAXB + 1 - J , L ) = CXMA ( MANF - MAUF + I - 1 ) END IF 36 CONTINUE 16 CONTINUE END SUBROUTINE PHSYMCUT SUBROUTINE PHGPNS ( CXMN , FELD , Z , WSAVE , IFAX , J , MNAUF , MAUF , MANF , MAXL , MAXB , MLEVEL ) IMPLICIT NONE INTEGER , INTENT ( IN ) :: MNAUF , MAUF , MANF , J , MAXL , MAXB , MLEVEL REAL :: CXM ( 0 : MAXAUF - 1 ) REAL , INTENT ( IN ) :: Z ( 0 :(( MNAUF + 3 ) * ( MNAUF + 4 )) / 2 , MAXB ) REAL , INTENT ( IN ) :: CXMN ( 0 :( MNAUF + 1 ) * ( MNAUF + 2 ) - 1 , MLEVEL ) REAL , INTENT ( IN ) :: WSAVE ( 4 * MAUF + 15 ) REAL :: FELD ( MAXL , MAXB , MLEVEL ) INTEGER :: IFAX ( 10 ) INTEGER I , L DO L = 1 , MLEVEL CALL LEGTR ( CXMN (:, L ), CXM , Z (:, J ), MNAUF , MAUF ) CALL RFOURTR ( CXM , WSAVE , IFAX , MNAUF , MAUF , 1 ) DO I = 0 , MAXL - 1 IF ( MANF + I . LE . MAUF ) THEN FELD ( I + 1 , J , L ) = CXM ( MANF + I - 1 ) ELSE FELD ( I + 1 , J , L ) = CXM ( MANF - MAUF + I - 1 ) END IF END DO END DO END SUBROUTINE PHGPNS SUBROUTINE LEGTR ( CXMN , CXM , Z , MNAUF , MAUF ) !! Calculate the Fourier coefficients CXM IMPLICIT NONE INTEGER MNAUF , MAUF , LL , LLP , I , J REAL CXM ( 0 : MAXAUF - 1 ) REAL CXMN ( 0 :( MNAUF + 1 ) * ( MNAUF + 2 ) - 1 ) REAL Z ( 0 :(( MNAUF + 3 ) * ( MNAUF + 4 )) / 2 ) REAL CI , CR LL = 0 LLP = 0 DO 1 I = 0 , MNAUF CR = 0.D0 CI = 0.D0 DO 2 J = I , MNAUF CR = CR + Z ( LLP ) * CXMN ( 2 * LL ) CI = CI + Z ( LLP ) * CXMN ( 2 * LL + 1 ) LL = LL + 1 LLP = LLP + 1 2 CONTINUE LLP = LLP + 2 CXM ( 2 * I ) = CR CXM ( 2 * I + 1 ) = CI 1 CONTINUE RETURN END SUBROUTINE LEGTR SUBROUTINE RFOURTR ( CXM , TRIGS , IFAX , MNAUF , MAXL , ISIGN ) !!  Calculates the Fourier sum with an FFT algorithm IMPLICIT REAL ( A - H , O - Z ) DIMENSION CXM ( 0 : MAXAUF - 1 ) REAL :: WSAVE ( 2 * MAXL ), TRIGS ( 2 * MAXL ) INTEGER IFAX ( 10 ) DO I = MNAUF + 1 , MAXL - 1 CXM ( 2 * I ) = 0.0 CXM ( 2 * I + 1 ) = 0.0 END DO CALL FFT99 ( CXM , WSAVE , TRIGS , IFAX , 1 , 1 , MAXL , 1 , 1 ) DO I = 0 , MAXL - 1 CXM ( I ) = CXM ( I + 1 ) END DO RETURN END SUBROUTINE RFOURTR SUBROUTINE GAULEG ( X1 , X2 , X , W , N ) !! Calculates the Gaussian latitudes IMPLICIT REAL ( A - H , O - Z ) DIMENSION X ( N ), W ( N ) PARAMETER ( EPS = 3.D-14 ) M = ( N + 1 ) / 2 XM = 0.5D0 * ( X2 + X1 ) XL = 0.5D0 * ( X2 - X1 ) DO 12 I = 1 , M Z = DCOS ( 3.141592654D0 * ( I - . 25 D0 ) / ( N + . 5 D0 )) 1 CONTINUE P1 = 1.D0 P2 = 0.D0 DO 11 J = 1 , N P3 = P2 P2 = P1 P1 = (( 2.D0 * J - 1.D0 ) * Z * P2 - ( J - 1.D0 ) * P3 ) / J 11 CONTINUE PP = N * ( Z * P1 - P2 ) / ( Z * Z - 1.D0 ) Z1 = Z Z = Z1 - P1 / PP IF ( ABS ( Z - Z1 ) . GT . EPS ) GO TO 1 X ( I ) = XM - XL * Z X ( N + 1 - I ) = XM + XL * Z W ( I ) = 2.D0 * XL / (( 1.D0 - Z * Z ) * PP * PP ) W ( N + 1 - I ) = W ( I ) 12 CONTINUE RETURN END SUBROUTINE GAULEG SUBROUTINE PLGNFA ( LL , X , Z ) !! Calculates all normalised associated Legendre functions from !! P00(X) to PLL(X) and writes them into the field Z. !! The polynomials have indices as with ECMWF, i.e. !! P00,P10,P11,P20,P21,P22,... !! Otherwise, this subroutine is analogous to PLGNDN ! X IST DER COSINUS DES ZENITWINKELS ODER !       DER SINUS DER GEOGRAFISCHEN BREITE IMPLICIT REAL ( A - H , O - Z ) DIMENSION Z ( 0 :(( LL + 3 ) * ( LL + 4 )) / 2 ) L = LL + 2 I = 1 Z ( 0 ) = 1.D0 FACT = 1.D0 POT = 1.D0 SOMX2 = DSQRT ( 1.D0 - X * X ) DO 14 J = 0 , L DJ = DBLE ( J ) IF ( J . GT . 0 ) THEN FACT = FACT * ( 2.D0 * DJ - 1.D0 ) / ( 2.D0 * DJ ) POT = POT * SOMX2 Z ( I ) = DSQRT (( 2.D0 * DJ + 1.D0 ) * FACT ) * POT I = I + 1 END IF IF ( J . LT . L ) THEN Z ( I ) = X * DSQRT (( 4.D0 * DJ * DJ + 8.D0 * DJ + 3.D0 ) / ( 2.D0 * DJ + 1.D0 )) * Z ( I - 1 ) I = I + 1 END IF DK = DJ + 2.D0 DO 14 K = J + 2 , L DDK = ( DK * DK - DJ * DJ ) Z ( I ) = X * DSQRT (( 4.D0 * DK * DK - 1.D0 ) / DDK ) * Z ( I - 1 ) - & DSQRT ((( 2.D0 * DK + 1.D0 ) * ( DK - DJ - 1.D0 ) * ( DK + DJ - 1.D0 )) / & (( 2.D0 * DK - 3.D0 ) * DDK )) * Z ( I - 2 ) DK = DK + 1.D0 I = I + 1 14 CONTINUE RETURN END SUBROUTINE PLGNFA SUBROUTINE DPLGND ( MNAUF , Z , DZ ) !! Calculates the derivatives of the normalised associated Legendre function !! from P00(X) to PLL(X) and writes them into the field DZ. !! Order is P00(X),P01(X),P11(X),P02(X),P12(X),P22(X),..PLL(X) IMPLICIT REAL ( A - H , O - Z ) DIMENSION Z ( 0 :(( MNAUF + 3 ) * ( MNAUF + 4 )) / 2 ) DIMENSION DZ ( 0 :(( MNAUF + 2 ) * ( MNAUF + 3 )) / 2 ) IF ( Z ( 0 ) . NE . 1.D0 ) THEN WRITE ( * , * ) 'DPLGND: Z(0) must be 1.0' STOP END IF LLP = 0 LLH = 0 DO 1 I = 0 , MNAUF + 1 DO 2 J = I , MNAUF + 1 IF ( I . EQ . J ) THEN WURZELA = DSQRT ( DBLE (( J + 1 ) * ( J + 1 ) - I * I ) / DBLE ( 4 * ( J + 1 ) * ( J + 1 ) - 1 )) DZ ( LLH ) = DBLE ( J ) * WURZELA * Z ( LLP + 1 ) ELSE WURZELB = DSQRT ( DBLE (( J + 1 ) * ( J + 1 ) - I * I ) / DBLE ( 4 * ( J + 1 ) * ( J + 1 ) - 1 )) DZ ( LLH ) = DBLE ( J ) * WURZELB * Z ( LLP + 1 ) - DBLE ( J + 1 ) * WURZELA * Z ( LLP - 1 ) WURZELA = WURZELB END IF LLH = LLH + 1 LLP = LLP + 1 2 CONTINUE LLP = LLP + 1 1 CONTINUE RETURN END SUBROUTINE DPLGND SUBROUTINE SPFILTER ( FELDMN , MM , MMAX ) !! Implements spectral filter of Sardeshmukh and Hoskins (MWR 1984) ! MM=Spectral truncation of field ! MMAX= Spectral truncation of filter IMPLICIT NONE INTEGER MM , MMAX , I , J , K , L REAL FELDMN ( 0 :( MM + 1 ) * ( MM + 2 ) - 1 ) REAL KMAX , SMAX , FAK SMAX = 0.1 KMAX =- ALOG ( SMAX ) KMAX = KMAX / ( float ( MMAX ) * float ( MMAX + 1 )) ** 2 !    WRITE(*,*)'alogsmax',alog(smax),'KMAX:',KMAX L = 0 DO I = 0 , MM DO J = I , MM !        WRITE(*,*) I,J,FELD(K),FELD(K)*EXP(-KMAX*(J*(J+1))**2) IF ( J . LE . MMAX ) THEN !          FAK=EXP(-KMAX*(J*(J+1))**2) FAK = 1.0 FELDMN ( 2 * L ) = FELDMN ( 2 * L ) * FAK FELDMN ( 2 * L + 1 ) = FELDMN ( 2 * L + 1 ) * FAK ELSE FELDMN ( 2 * L ) = 0. FELDMN ( 2 * L + 1 ) = 0. END IF L = L + 1 END DO END DO END SUBROUTINE SPFILTER END MODULE PHTOGR","tags":"","loc":"sourcefile/phgrreal.f90.html","title":"phgrreal.f90 – Flex_extract: Calculation of etadot"},{"text":"Contents Subroutines POSNAM Source Code posnam.f90 Source Code SUBROUTINE POSNAM ( KULNAM , CDNAML ) !! Position in namelist file. !! Author:  Mats Hamrud, ECMWF INTEGER , INTENT ( IN ) :: KULNAM CHARACTER * ( * ), INTENT ( IN ) :: CDNAML CHARACTER * 120 CLINE CHARACTER * 1 CLTEST REWIND ( KULNAM ) ILEN = LEN ( CDNAML ) 102 CONTINUE CLINE = ' ' READ ( KULNAM , '(A)' ) CLINE IND1 = INDEX ( CLINE , '&' // CDNAML ) IF ( IND1 . EQ . 0 ) GO TO 102 CLTEST = CLINE ( IND1 + ILEN + 1 : IND1 + ILEN + 1 ) IF ( LGE ( CLTEST , '0' ) . AND . LLE ( CLTEST , '9' ) . OR . & LGE ( CLTEST , 'A' ) . AND . LLE ( CLTEST , 'Z' )) GOTO 102 BACKSPACE ( KULNAM ) RETURN END SUBROUTINE POSNAM","tags":"","loc":"sourcefile/posnam.f90.html","title":"posnam.f90 – Flex_extract: Calculation of etadot"},{"text":"This file depends on sourcefile~~ftrafo.f90~~EfferentGraph sourcefile~ftrafo.f90 ftrafo.f90 sourcefile~phgrreal.f90 phgrreal.f90 sourcefile~ftrafo.f90->sourcefile~phgrreal.f90 Help × Graph Key Nodes of different colours represent the following: Graph Key Source File Source File This Page's Entity This Page's Entity Solid arrows point from a file to a file which it depends on. A file\n    is dependent upon another if the latter must be compiled before the former\n    can be. Files dependent on this one sourcefile~~ftrafo.f90~~AfferentGraph sourcefile~ftrafo.f90 ftrafo.f90 sourcefile~calc_etadot.f90 calc_etadot.f90 sourcefile~calc_etadot.f90->sourcefile~ftrafo.f90 Help × Graph Key Nodes of different colours represent the following: Graph Key Source File Source File This Page's Entity This Page's Entity Solid arrows point from a file to a file which it depends on. A file\n    is dependent upon another if the latter must be compiled before the former\n    can be. Contents Modules FTRAFO Source Code ftrafo.f90 Source Code MODULE FTRAFO !! Implementation of the spectral transformation using the reduced Gaussian grid CONTAINS SUBROUTINE VDTOUV ( XMN , XLAM , XPHI , GWSAVE , IFAX , P , MLAT , MNAUF , NI , NJ , NK ) !! Calculates scale winds from vorticity and divergence. !! If in XMN the divergence is passed, then the divergent part of the wind !! (XPHI=Ud,XPHI=Vd) is returned. If vorticity is passed, then the !! rotational part of the wind (XLAM=Vrot,XPHI=-Urot) is returned. !! Summing both, one obtains the whole scale wind. ! GWSAVE ist ein Hilfsfeld fuer die FFT ! P enthaelt die assoziierten Legendrepolynome, H deren Ableitung ! MLAT enthaelt die Anzahl der Gitterpunkte pro Breitenkreis ! MNAUF gibt die spektrale Aufloesung an, ! NI = Anzahl der Gauss'schen Gitterpunkte pro Flaeche ! NJ = Anzahl der Gauss'schen Breiten, ! NK = Anzahl der Niveaus USE PHTOGR IMPLICIT NONE INTEGER J , N , NI , NJ , NK , MNAUF , GGIND ( NJ / 2 ) INTEGER MLAT ( NJ ), IFAX ( 10 , NJ ) REAL XMN ( 0 :( MNAUF + 1 ) * ( MNAUF + 2 ) - 1 , NK ) REAL P ( 0 :( MNAUF + 3 ) * ( MNAUF + 4 ) / 2 , NJ / 2 ) REAL H ( 0 :( MNAUF + 2 ) * ( MNAUF + 3 ) / 2 ) REAL XLAM ( NI , NK ), XPHI ( NI , NK ) REAL GWSAVE ( 8 * NJ + 15 , NJ / 2 ) REAL SCR , SCI , ACR , ACI , MUSCR , MUSCI , MUACR , MUACI REAL RT , IT GGIND ( 1 ) = 0 DO 4 J = 2 , NJ / 2 GGIND ( J ) = GGIND ( J - 1 ) + MLAT ( J - 1 ) 4 CONTINUE !$OMP PARALLEL DO SCHEDULE(DYNAMIC) DO 5 J = 1 , NJ / 2 CALL VDUVSUB ( J , XMN , XLAM , XPHI , GWSAVE , IFAX , P , GGIND ( J ), MLAT , MNAUF , NI , NJ , NK ) 5 CONTINUE !$OMP END PARALLEL DO RETURN END SUBROUTINE VDTOUV SUBROUTINE VDUVSUB ( J , XMN , XLAM , XPHI , GWSAVE , IFAX , P , GGIND , MLAT , MNAUF , NI , NJ , NK ) USE PHTOGR IMPLICIT NONE INTEGER J , K , M , N , NI , NJ , NK , MNAUF , GGIND , LL , LLP , LLH , LLS , LLPS , LLHS INTEGER MLAT ( NJ ), IFAX ( 10 , NJ ) REAL UFOUC ( 0 : MAXAUF ), MUFOUC ( 0 : MAXAUF ) REAL VFOUC ( 0 : MAXAUF ), MVFOUC ( 0 : MAXAUF ) REAL XMN ( 0 :( MNAUF + 1 ) * ( MNAUF + 2 ) - 1 , NK ) REAL P ( 0 :( MNAUF + 3 ) * ( MNAUF + 4 ) / 2 , NJ / 2 ) REAL H ( 0 :( MNAUF + 2 ) * ( MNAUF + 3 ) / 2 ) REAL XLAM ( NI , NK ), XPHI ( NI , NK ) REAL GWSAVE ( 8 * NJ + 15 , NJ / 2 ) REAL ERAD , SCR , SCI , ACR , ACI , MUSCR , MUSCI , MUACR , MUACI REAL FAC ( 0 : MNAUF ), RT , IT ERAD = 636747 0.D0 FAC ( 0 ) = 0.D0 DO 12 N = 1 , MNAUF FAC ( N ) =- ERAD / DBLE ( N ) / DBLE ( N + 1 ) 12 CONTINUE CALL DPLGND ( MNAUF , P ( 0 , J ), H ) DO 3 K = 1 , NK LL = 0 LLP = 0 LLH = 0 DO 2 M = 0 , MNAUF SCR = 0.D0 SCI = 0.D0 ACR = 0.D0 ACI = 0.D0 MUSCR = 0.D0 MUSCI = 0.D0 MUACR = 0.D0 MUACI = 0.D0 LLS = LL LLPS = LLP LLHS = LLH IF ( 2 * M + 1 . LT . MLAT ( J )) THEN DO 1 N = M , MNAUF , 2 RT = XMN ( 2 * LL , K ) * FAC ( N ) IT = XMN ( 2 * LL + 1 , K ) * FAC ( N ) SCR = SCR + RT * P ( LLP , J ) SCI = SCI + IT * P ( LLP , J ) MUACR = MUACR + RT * H ( LLH ) MUACI = MUACI + IT * H ( LLH ) LL = LL + 2 LLP = LLP + 2 LLH = LLH + 2 1 CONTINUE LL = LLS + 1 LLP = LLPS + 1 LLH = LLHS + 1 DO 11 N = M + 1 , MNAUF , 2 RT = XMN ( 2 * LL , K ) * FAC ( N ) IT = XMN ( 2 * LL + 1 , K ) * FAC ( N ) ACR = ACR + RT * P ( LLP , J ) ACI = ACI + IT * P ( LLP , J ) MUSCR = MUSCR + RT * H ( LLH ) MUSCI = MUSCI + IT * H ( LLH ) LL = LL + 2 LLP = LLP + 2 LLH = LLH + 2 11 CONTINUE END IF LL = LLS + ( MNAUF - M + 1 ) LLP = LLPS + ( MNAUF - M + 3 ) LLH = LLHS + ( MNAUF - M + 2 ) UFOUC ( 2 * M ) =- M * ( SCI - ACI ) UFOUC ( 2 * M + 1 ) = M * ( SCR - ACR ) VFOUC ( 2 * M ) =- M * ( SCI + ACI ) VFOUC ( 2 * M + 1 ) = M * ( SCR + ACR ) MUFOUC ( 2 * M ) =- ( MUSCR - MUACR ) MUFOUC ( 2 * M + 1 ) =- ( MUSCI - MUACI ) MVFOUC ( 2 * M ) =- ( MUSCR + MUACR ) MVFOUC ( 2 * M + 1 ) =- ( MUSCI + MUACI ) 2 CONTINUE CALL RFOURTR ( VFOUC , GWSAVE (:, J ), IFAX (:, J ), MNAUF , MLAT ( J ), 1 ) XLAM ( GGIND + 1 : GGIND + MLAT ( J ), K ) = VFOUC ( 0 : MLAT ( J ) - 1 ) CALL RFOURTR ( UFOUC , GWSAVE (:, J ), IFAX (:, J ), MNAUF , MLAT ( J ), 1 ) XLAM ( NI - GGIND - MLAT ( J ) + 1 : NI - GGIND , K ) = UFOUC ( 0 : MLAT ( J ) - 1 ) CALL RFOURTR ( MVFOUC , GWSAVE (:, J ), IFAX (:, J ), MNAUF , MLAT ( J ), 1 ) XPHI ( GGIND + 1 : GGIND + MLAT ( J ), K ) = MVFOUC ( 0 : MLAT ( J ) - 1 ) CALL RFOURTR ( MUFOUC , GWSAVE (:, J ), IFAX (:, J ), MNAUF , MLAT ( J ), 1 ) XPHI ( NI - GGIND - MLAT ( J ) + 1 : NI - GGIND , K ) = MUFOUC ( 0 : MLAT ( J ) - 1 ) 3 CONTINUE RETURN END SUBROUTINE VDUVSUB SUBROUTINE PHGRAD ( XMN , XLAM , XPHI , GWSAVE , IFAX , P , H , MLAT , MNAUF , NI , NJ , NK ) !! Calculates the gradient of a scalar from the field of the scalar XMN !! in phase space. Returns fields of the componentens of the horizontal !! gradients XLAM,XPHI on the Gaussian grid. ! GWSAVE ist ein Hilfsfeld fuer die FFT ! P enthaelt die assoziierten Legendrepolynome, H deren Ableitung ! MLAT enthaelt die Anzahl der Gitterpunkte pro Breitenkreis ! MNAUF gibt die spektrale Aufloesung an, ! NI = Anzahl der Gauss'schen Gitterpunkte, ! NJ = Anzahl der Gauss'schen Breiten, ! NK = Anzahl der Niveaus USE PHTOGR IMPLICIT NONE INTEGER J , K , M , N , NI , NJ , NK , MNAUF , GGIND , LL , LLP , LLH , LLS , LLPS , LLHS INTEGER MLAT ( NJ ), IFAX ( 10 , NJ ) REAL UFOUC ( 0 : MAXAUF ), MUFOUC ( 0 : MAXAUF ) REAL VFOUC ( 0 : MAXAUF ), MVFOUC ( 0 : MAXAUF ) REAL XMN ( 0 :( MNAUF + 1 ) * ( MNAUF + 2 ) - 1 , NK ) REAL P ( 0 :( MNAUF + 3 ) * ( MNAUF + 4 ) / 2 , NJ / 2 ) REAL H ( 0 :( MNAUF + 2 ) * ( MNAUF + 3 ) / 2 ) REAL XLAM ( NI , NK ), XPHI ( NI , NK ) REAL GWSAVE ( 8 * NJ + 15 , NJ / 2 ) REAL ERAD REAL SCR , SCI , ACR , ACI , MUSCR , MUSCI , MUACR , MUACI , RT , IT ERAD = 636747 0.0 GGIND = 0 DO 4 J = 1 , NJ / 2 CALL DPLGND ( MNAUF , P ( 0 , J ), H ) DO 3 K = 1 , NK LL = 0 LLP = 0 LLH = 0 DO 2 M = 0 , MNAUF SCR = 0.D0 SCI = 0.D0 ACR = 0.D0 ACI = 0.D0 MUSCR = 0.D0 MUSCI = 0.D0 MUACR = 0.D0 MUACI = 0.D0 LLS = LL LLPS = LLP LLHS = LLH IF ( 2 * M + 1 . LT . MLAT ( J )) THEN DO 1 N = M , MNAUF , 2 RT = XMN ( 2 * LL , K ) IT = XMN ( 2 * LL + 1 , K ) SCR = SCR + RT * P ( LLP , J ) SCI = SCI + IT * P ( LLP , J ) MUACR = MUACR + RT * H ( LLH ) MUACI = MUACI + IT * H ( LLH ) LL = LL + 2 LLP = LLP + 2 LLH = LLH + 2 1 CONTINUE LL = LLS + 1 LLP = LLPS + 1 LLH = LLHS + 1 DO 11 N = M + 1 , MNAUF , 2 RT = XMN ( 2 * LL , K ) IT = XMN ( 2 * LL + 1 , K ) ACR = ACR + RT * P ( LLP , J ) ACI = ACI + IT * P ( LLP , J ) MUSCR = MUSCR + RT * H ( LLH ) MUSCI = MUSCI + IT * H ( LLH ) LL = LL + 2 LLP = LLP + 2 LLH = LLH + 2 11 CONTINUE END IF LL = LLS + ( MNAUF - M + 1 ) LLP = LLPS + ( MNAUF - M + 3 ) LLH = LLHS + ( MNAUF - M + 2 ) UFOUC ( 2 * M ) =- M * ( SCI - ACI ) / ERAD UFOUC ( 2 * M + 1 ) = M * ( SCR - ACR ) / ERAD VFOUC ( 2 * M ) =- M * ( SCI + ACI ) / ERAD VFOUC ( 2 * M + 1 ) = M * ( SCR + ACR ) / ERAD MUFOUC ( 2 * M ) =- ( MUSCR - MUACR ) / ERAD MUFOUC ( 2 * M + 1 ) =- ( MUSCI - MUACI ) / ERAD MVFOUC ( 2 * M ) =- ( MUSCR + MUACR ) / ERAD MVFOUC ( 2 * M + 1 ) =- ( MUSCI + MUACI ) / ERAD 2 CONTINUE CALL RFOURTR ( VFOUC , GWSAVE (:, J ), IFAX (:, J ), MNAUF , MLAT ( J ), 1 ) XLAM ( GGIND + 1 : GGIND + MLAT ( J ), K ) = VFOUC ( 0 : MLAT ( J ) - 1 ) CALL RFOURTR ( UFOUC , GWSAVE (:, J ), IFAX (:, J ), MNAUF , MLAT ( J ), 1 ) XLAM ( NI - GGIND - MLAT ( J ) + 1 : NI - GGIND , K ) = UFOUC ( 0 : MLAT ( J ) - 1 ) CALL RFOURTR ( MVFOUC , GWSAVE (:, J ), IFAX (:, J ), MNAUF , MLAT ( J ), 1 ) XPHI ( GGIND + 1 : GGIND + MLAT ( J ), K ) = MVFOUC ( 0 : MLAT ( J ) - 1 ) CALL RFOURTR ( MUFOUC , GWSAVE (:, J ), IFAX (:, J ), MNAUF , MLAT ( J ), 1 ) XPHI ( NI - GGIND - MLAT ( J ) + 1 : NI - GGIND , K ) = MUFOUC ( 0 : MLAT ( J ) - 1 ) 3 CONTINUE GGIND = GGIND + MLAT ( J ) 4 CONTINUE RETURN END SUBROUTINE PHGRAD SUBROUTINE PHGRACUT ( XMN , XLAM , XPHI , GWSAVE , IFAX , P , H , MAUF , MNAUF , NI , NJ , MANF , NK ) !! Calculated the gradient of a scalar from the field of the scalar XMN !! in phase space. Returns the fields of the components of the horizontal !! gradient XLAM,XPHI on the Gaussian grid ! GWSAVE ist ein Hilfsfeld fuer die FFT ! P enthaelt die assoziierten Legendrepolynome, H deren Ableitung ! MLAT enthaelt die Anzahl der Gitterpunkte pro Breitenkreis ! MNAUF gibt die spektrale Aufloesung an, ! NI = Anzahl der Gauss'schen Gitterpunkte, ! NJ = Anzahl der Gauss'schen Breiten, ! NK = Anzahl der Niveaus USE PHTOGR IMPLICIT NONE INTEGER J , K , M , N , NI , NJ , NK , MNAUF , GGIND , LL , LLP , LLH , LLS , LLPS , LLHS INTEGER MAUF , MANF , I , IFAX ( 10 ) REAL UFOUC ( 0 : MAXAUF ), MUFOUC ( 0 : MAXAUF ) REAL VFOUC ( 0 : MAXAUF ), MVFOUC ( 0 : MAXAUF ) REAL XMN ( 0 :( MNAUF + 1 ) * ( MNAUF + 2 ) - 1 , NK ) REAL P ( 0 :( MNAUF + 3 ) * ( MNAUF + 4 ) / 2 , NJ ) REAL H ( 0 :( MNAUF + 2 ) * ( MNAUF + 3 ) / 2 ) REAL XLAM ( NI , NJ , NK ), XPHI ( NI , NJ , NK ) REAL HLAM ( MAXAUF , 2 ), HPHI ( MAXAUF , 2 ) REAL GWSAVE ( 4 * MAUF + 15 ) REAL ERAD REAL SCR , SCI , ACR , ACI , MUSCR , MUSCI , MUACR , MUACI , RT , IT ERAD = 636747 0.0 GGIND = 0 DO 4 J = 1 , NJ CALL DPLGND ( MNAUF , P ( 0 , J ), H ) DO 3 K = 1 , NK LL = 0 LLP = 0 LLH = 0 DO 2 M = 0 , MNAUF SCR = 0.D0 SCI = 0.D0 ACR = 0.D0 ACI = 0.D0 MUSCR = 0.D0 MUSCI = 0.D0 MUACR = 0.D0 MUACI = 0.D0 LLS = LL LLPS = LLP LLHS = LLH IF ( 2 * M + 1 . LT . MAUF ) THEN DO 1 N = M , MNAUF , 2 RT = XMN ( 2 * LL , K ) IT = XMN ( 2 * LL + 1 , K ) SCR = SCR + RT * P ( LLP , J ) SCI = SCI + IT * P ( LLP , J ) MUACR = MUACR + RT * H ( LLH ) MUACI = MUACI + IT * H ( LLH ) LL = LL + 2 LLP = LLP + 2 LLH = LLH + 2 1 CONTINUE LL = LLS + 1 LLP = LLPS + 1 LLH = LLHS + 1 DO 11 N = M + 1 , MNAUF , 2 RT = XMN ( 2 * LL , K ) IT = XMN ( 2 * LL + 1 , K ) ACR = ACR + RT * P ( LLP , J ) ACI = ACI + IT * P ( LLP , J ) MUSCR = MUSCR + RT * H ( LLH ) MUSCI = MUSCI + IT * H ( LLH ) LL = LL + 2 LLP = LLP + 2 LLH = LLH + 2 11 CONTINUE END IF LL = LLS + ( MNAUF - M + 1 ) LLP = LLPS + ( MNAUF - M + 3 ) LLH = LLHS + ( MNAUF - M + 2 ) UFOUC ( 2 * M ) =- M * ( SCI - ACI ) / ERAD UFOUC ( 2 * M + 1 ) = M * ( SCR - ACR ) / ERAD VFOUC ( 2 * M ) =- M * ( SCI + ACI ) / ERAD VFOUC ( 2 * M + 1 ) = M * ( SCR + ACR ) / ERAD MUFOUC ( 2 * M ) =- ( MUSCR - MUACR ) / ERAD MUFOUC ( 2 * M + 1 ) =- ( MUSCI - MUACI ) / ERAD MVFOUC ( 2 * M ) =- ( MUSCR + MUACR ) / ERAD MVFOUC ( 2 * M + 1 ) =- ( MUSCI + MUACI ) / ERAD 2 CONTINUE CALL RFOURTR ( VFOUC , GWSAVE , IFAX , MNAUF , MAUF , 1 ) CALL RFOURTR ( MVFOUC , GWSAVE , IFAX , MNAUF , MAUF , 1 ) DO 6 I = 0 , NI - 1 IF ( MANF + I . LE . MAUF ) THEN XLAM ( I + 1 , J , K ) = VFOUC ( MANF + I - 1 ) XPHI ( I + 1 , J , K ) = MVFOUC ( MANF + I - 1 ) ELSE XLAM ( I + 1 , J , K ) = VFOUC ( MANF - MAUF + I - 1 ) XPHI ( I + 1 , J , K ) = MVFOUC ( MANF - MAUF + I - 1 ) END IF 6 CONTINUE 3 CONTINUE GGIND = GGIND + MAUF 4 CONTINUE RETURN END SUBROUTINE PHGRACUT SUBROUTINE CONTGL ( PS , DPSDL , DPSDM , DIV , U , V , BREITE , ETA , MLAT , A , B , NI , NJ , NK ) !! Calculation of divergence from the wind field (U,V) !! in phase space. Returns fields of the componentens of the !! horizontal gradients XLAM,XPHI on the Gaussian grid ! GWSAVE ist ein Hilfsfeld fuer die FFT ! P enthaelt die assoziierten Legendrepolynome, H deren Ableitung ! MLAT enthaelt die Anzahl der Gitterpunkte pro Breitenkreis ! MNAUF gibt die spektrale Aufloesung an, ! NI = Anzahl der Gauss'schen Gitterpunkte, ! NJ = Anzahl der Gauss'schen Breiten, ! NK = Anzahl der Niveaus ! Beachte, dass das Windfeld eine um 1 erhoehte Aufloesung in mu-Richtung hat. IMPLICIT NONE INTEGER NI , NJ , NK , I , J , K , MLAT ( NJ ), L REAL A ( NK + 1 ), B ( NK + 1 ) REAL PS ( NI ), DPSDL ( NI ), DPSDM ( NI ) REAL DIV ( NI , NK ), U ( NI , NK ), V ( NI , NK ), ETA ( NI , NK ) REAL BREITE ( NJ ) REAL DIVT1 , DIVT2 , POB , PUN , DPSDT , COSB L = 0 DO 4 J = 1 , NJ COSB = ( 1.0 - BREITE ( J ) * BREITE ( J )) DO 3 I = 1 , MLAT ( J ) L = L + 1 DIVT1 = 0.0 DIVT2 = 0.0 DO 1 K = 1 , NK POB = A ( K ) + B ( K ) * PS ( L ) PUN = A ( K + 1 ) + B ( K + 1 ) * PS ( L ) DIVT1 = DIVT1 + DIV ( L , K ) * ( PUN - POB ) IF ( COSB . GT . 0. ) THEN DIVT2 = DIVT2 + ( B ( K + 1 ) - B ( K )) * PS ( L ) * & ( U ( L , K ) * DPSDL ( L ) + V ( L , K ) * DPSDM ( L )) / COSB END IF ETA ( L , K ) =- DIVT1 - DIVT2 1 CONTINUE DPSDT = ( - DIVT1 - DIVT2 ) / PS ( L ) DO 2 K = 1 , NK ETA ( L , K ) = ETA ( L , K ) - DPSDT * B ( K + 1 ) * PS ( L ) 2 CONTINUE PS ( L ) = DPSDT * PS ( L ) 3 CONTINUE 4 CONTINUE RETURN END SUBROUTINE CONTGL SUBROUTINE OMEGA ( PS , DPSDL , DPSDM , DIV , U , V , BREITE , E , MLAT , A , B , NGI , NGJ , MKK ) !! Calculates \\omega in the hybrid (\\eta-)coordinate system ! OMEGA berechnet omega im Hybridkoordinatensystem ! PS ist der Bodendruck, ! DPSDL,DPSDM sind die Komponenten des Gradienten des Logarithmus des ! Bodendrucks ! DIV,U,V sind die horizontale Divergenz und das horizontale Windfeld ! BREITE ist das Feld der Gauss'schen Breiten ! E ist omega, IMPLICIT NONE INTEGER I , J , K , L , NGI , NGJ , MKK , MLAT ( NGJ ) REAL PS ( NGI ), DPSDL ( NGI ), DPSDM ( NGI ), A ( MKK + 1 ), B ( MKK + 1 ) REAL DIV ( NGI , MKK ), U ( NGI , MKK ), V ( NGI , MKK ), E ( NGI , MKK ) REAL BREITE ( NGJ ) REAL DIVT1 , DIVT2 , POB , PUN , DP , X , Y , COSB REAL DIVT3 ( MKK + 2 ) L = 0 DO 4 J = 1 , NGJ COSB = ( 1.0 - BREITE ( J ) * BREITE ( J )) DO 3 I = 1 , MLAT ( J ) L = L + 1 DIVT1 = 0.0 DIVT2 = 0.0 DIVT3 ( 1 ) = 0.0 DO 1 K = 1 , MKK POB = A ( K ) + B ( K ) * PS ( L ) PUN = A ( K + 1 ) + B ( K + 1 ) * PS ( L ) DP = PUN - POB Y = PS ( L ) * ( U ( L , K ) * DPSDL ( L ) + V ( L , K ) * DPSDM ( L )) / COSB IF ( K . LT . 3 ) THEN X = 0.0 ELSE X = ( B ( K + 1 ) - B ( K )) * Y END IF DIVT1 = DIVT1 + DIV ( L , K ) * DP DIVT2 = DIVT2 + X DIVT3 ( K + 1 ) =- DIVT1 - DIVT2 IF ( K . GT . 1 ) THEN E ( L , K ) = 0.5 * ( POB + PUN ) / & DP * Y * (( B ( K + 1 ) - B ( K )) + ( A ( K + 1 ) * B ( K ) - A ( K ) * B ( K + 1 )) / DP * LOG ( PUN / POB )) ELSE E ( L , K ) = 0.0 END IF E ( L , K ) = E ( L , K ) + 0.5 * ( DIVT3 ( K ) + DIVT3 ( K + 1 )) 1 CONTINUE 3 CONTINUE 4 CONTINUE RETURN END SUBROUTINE OMEGA END MODULE FTRAFO","tags":"","loc":"sourcefile/ftrafo.f90.html","title":"ftrafo.f90 – Flex_extract: Calculation of etadot"},{"text":"function IA(FIELD1, NI, NJ, NK, G) Calculate something that is roughly log10( maxval(field1)/g ) [PS] Arguments Type Intent Optional Attributes Name real, intent(in) :: FIELD1 (NI,NJ,NK) integer, intent(in) :: NI integer, intent(in) :: NJ integer, intent(in) :: NK real, intent(in) :: G Return Value integer Contents None","tags":"","loc":"proc/ia.html","title":"IA – Flex_extract: Calculation of etadot"},{"text":"subroutine STATIS(NI, NJ, NK, PHI, RMS, MW, SIG) calculate mean, rms, stdev Arguments Type Intent Optional Attributes Name integer :: NI integer :: NJ integer :: NK real :: PHI (NI,NJ,NK) real :: RMS real :: MW real :: SIG Called by proc~~statis~~CalledByGraph proc~statis STATIS program~calc_etadot calc_etadot program~calc_etadot->proc~statis Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Contents None","tags":"","loc":"proc/statis.html","title":"STATIS – Flex_extract: Calculation of etadot"},{"text":"subroutine POSNAM(KULNAM, CDNAML) Position in namelist file.\n Author:  Mats Hamrud, ECMWF Arguments Type Intent Optional Attributes Name integer, intent(in) :: KULNAM character(len=*), intent(in) :: CDNAML Called by proc~~posnam~~CalledByGraph proc~posnam POSNAM program~calc_etadot calc_etadot program~calc_etadot->proc~posnam Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Contents None","tags":"","loc":"proc/posnam.html","title":"POSNAM – Flex_extract: Calculation of etadot"},{"text":"public subroutine READLATLON(filename, feld, maxl, maxb, mlevel, mpar) Uses GRIB_API proc~~readlatlon~~UsesGraph proc~readlatlon READLATLON GRIB_API GRIB_API proc~readlatlon->GRIB_API Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Read a field from GRIB file on lat-lon grid Arguments Type Intent Optional Attributes Name character(len=*) :: filename real, dimension(maxl,maxb,mlevel) :: feld integer :: maxl integer :: maxb integer :: mlevel integer :: mpar (:) Calls proc~~readlatlon~~CallsGraph proc~readlatlon READLATLON grib_count_in_file grib_count_in_file proc~readlatlon->grib_count_in_file grib_close_file grib_close_file proc~readlatlon->grib_close_file Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Called by proc~~readlatlon~~CalledByGraph proc~readlatlon READLATLON program~calc_etadot calc_etadot program~calc_etadot->proc~readlatlon Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Contents None","tags":"","loc":"proc/readlatlon.html","title":"READLATLON – Flex_extract: Calculation of etadot"},{"text":"public subroutine WRITELATLON(IUNIT, igrib, ogrib, FELD, MAXL, MAXB, MLEVEL, MLEVELIST, MSTRIDE, MPAR) Uses GRIB_API proc~~writelatlon~~UsesGraph proc~writelatlon WRITELATLON GRIB_API GRIB_API proc~writelatlon->GRIB_API Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. write a field on lat-lon grid to GRIB file Arguments Type Intent Optional Attributes Name integer :: IUNIT integer :: igrib integer :: ogrib real :: FELD (MAXL,MAXB,MLEVEL) integer :: MAXL integer :: MAXB integer :: MLEVEL character(len=*) :: MLEVELIST integer :: MSTRIDE integer :: MPAR (MSTRIDE) Calls proc~~writelatlon~~CallsGraph proc~writelatlon WRITELATLON grib_write grib_write proc~writelatlon->grib_write grib_set grib_set proc~writelatlon->grib_set Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Contents None","tags":"","loc":"proc/writelatlon.html","title":"WRITELATLON – Flex_extract: Calculation of etadot"},{"text":"public subroutine READSPECTRAL(filename, CXMN, mnauf, mlevel, maxlev, mpar, A, B) Uses GRIB_API proc~~readspectral~~UsesGraph proc~readspectral READSPECTRAL GRIB_API GRIB_API proc~readspectral->GRIB_API Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Read a GRIB file in spherical harmonics Arguments Type Intent Optional Attributes Name character(len=*) :: filename real :: CXMN (0:(MNAUF+1)*(MNAUF+2)-1,MLEVEL) integer :: mnauf integer :: mlevel integer :: maxlev integer :: mpar (:) real :: A (MAXLEV+1) real :: B (MAXLEV+1) Calls proc~~readspectral~~CallsGraph proc~readspectral READSPECTRAL grib_count_in_file grib_count_in_file proc~readspectral->grib_count_in_file grib_close_file grib_close_file proc~readspectral->grib_close_file Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Called by proc~~readspectral~~CalledByGraph proc~readspectral READSPECTRAL program~calc_etadot calc_etadot program~calc_etadot->proc~readspectral Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Contents None","tags":"","loc":"proc/readspectral.html","title":"READSPECTRAL – Flex_extract: Calculation of etadot"},{"text":"public subroutine GRPH213(CXMN, FELD, WSAVE, IFAX, Z, W, MLAT, MNAUF, MAXL, MAXB, MLEVEL) Arguments Type Intent Optional Attributes Name real :: CXMN real :: FELD (MAXL,MLEVEL) real :: WSAVE integer :: IFAX (10,MAXB) real :: Z (MAXB/2,0:((MNAUF+3)*(MNAUF+4))/2) real :: W (MAXB) integer :: MLAT (MAXB) integer :: MNAUF integer :: MAXL integer :: MAXB integer :: MLEVEL Calls proc~~grph213~~CallsGraph proc~grph213 GRPH213 ind ind proc~grph213->ind proc~grphsub GRPHSUB proc~grph213->proc~grphsub Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Called by proc~~grph213~~CalledByGraph proc~grph213 GRPH213 program~calc_etadot calc_etadot program~calc_etadot->proc~grph213 Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Contents None","tags":"","loc":"proc/grph213.html","title":"GRPH213 – Flex_extract: Calculation of etadot"},{"text":"public subroutine GRPHSUB(L, IND, CXMN, FELD, WSAVE, IFAX, Z, W, MLAT, MNAUF, MAXL, MAXB, MLEVEL) Carries out the transformation from the phase space into the physical\n space on spherical coordinates Arguments Type Intent Optional Attributes Name integer :: L integer :: IND (MAXB) real :: CXMN (0:(MNAUF+1)*(MNAUF+2)-1,MLEVEL) real :: FELD (MAXL,MLEVEL) real :: WSAVE (8*MAXB+15,MAXB/2) integer :: IFAX (10,MAXB) real :: Z (MAXB/2,0:((MNAUF+3)*(MNAUF+4))/2) real :: W (MAXB) integer :: MLAT (MAXB) integer :: MNAUF integer :: MAXL integer :: MAXB integer :: MLEVEL Called by proc~~grphsub~~CalledByGraph proc~grphsub GRPHSUB proc~grph213 GRPH213 proc~grph213->proc~grphsub program~calc_etadot calc_etadot program~calc_etadot->proc~grph213 Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Contents None","tags":"","loc":"proc/grphsub.html","title":"GRPHSUB – Flex_extract: Calculation of etadot"},{"text":"public subroutine LGTR213(CXMN, CXM, Z, W, MLAT, MNAUF, MAXB) Calculates the KFFKs (Fourier coefficients) CXMN Arguments Type Intent Optional Attributes Name real :: CXMN real :: CXM real(kind=8) :: Z (MAXB/2,0:((MNAUF+3)*(MNAUF+4))/2) real(kind=8) :: W (MAXB) integer :: MLAT (MAXB) integer :: MNAUF integer :: MAXB Contents None","tags":"","loc":"proc/lgtr213.html","title":"LGTR213 – Flex_extract: Calculation of etadot"},{"text":"public subroutine RFOUFTR(CXM, TRIGS, IFAX, MNAUF, MAXL, ISIGN) Calculates the Fourier sum with an FFT algorithm Arguments Type Intent Optional Attributes Name real :: CXM real :: TRIGS integer :: IFAX (10) integer :: MNAUF integer :: MAXL integer :: ISIGN Calls proc~~rfouftr~~CallsGraph proc~rfouftr RFOUFTR wsave wsave proc~rfouftr->wsave fft99 fft99 proc~rfouftr->fft99 Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Contents None","tags":"","loc":"proc/rfouftr.html","title":"RFOUFTR – Flex_extract: Calculation of etadot"},{"text":"public subroutine PHGR213(CXMN, FELD, WSAVE, IFAX, Z, MLAT, MNAUF, MAXL, MAXB, MLEVEL) Arguments Type Intent Optional Attributes Name real :: CXMN (0:(MNAUF+1)*(MNAUF+2)-1,MLEVEL) real :: FELD (MAXL,MLEVEL) real :: WSAVE (8*MAXB+15,MAXB/2) integer :: IFAX (10,MAXB) real :: Z (0:((MNAUF+3)*(MNAUF+4))/2,MAXB/2) integer :: MLAT (MAXB/2) integer :: MNAUF integer :: MAXL integer :: MAXB integer :: MLEVEL Calls proc~~phgr213~~CallsGraph proc~phgr213 PHGR213 proc~phsym PHSYM proc~phgr213->proc~phsym Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Called by proc~~phgr213~~CalledByGraph proc~phgr213 PHGR213 program~calc_etadot calc_etadot program~calc_etadot->proc~phgr213 Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Contents None","tags":"","loc":"proc/phgr213.html","title":"PHGR213 – Flex_extract: Calculation of etadot"},{"text":"public subroutine PHSYM(K, IND, CXMN, FELD, Z, WSAVE, IFAX, MLAT, MNAUF, MAXL, MAXB, MLEVEL) Arguments Type Intent Optional Attributes Name integer :: K integer :: IND (MAXB) real :: CXMN (0:(MNAUF+1)*(MNAUF+2)-1,MLEVEL) real :: FELD (MAXL,MLEVEL) real :: Z (0:((MNAUF+3)*(MNAUF+4))/2,MAXB/2) real :: WSAVE (8*MAXB+15,MAXB/2) integer :: IFAX (10,MAXB) integer :: MLAT (MAXB/2) integer :: MNAUF integer :: MAXL integer :: MAXB integer :: MLEVEL Called by proc~~phsym~~CalledByGraph proc~phsym PHSYM proc~phgr213 PHGR213 proc~phgr213->proc~phsym program~calc_etadot calc_etadot program~calc_etadot->proc~phgr213 Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Contents None","tags":"","loc":"proc/phsym.html","title":"PHSYM – Flex_extract: Calculation of etadot"},{"text":"public subroutine PHGCUT(CXMN, FELD, WSAVE, IFAX, Z, MNAUF, MMAX, MAUF, MANF, MAXL, MAXB, MLEVEL) Carries out the transformation of a field variable from the phase space\n into the physical space on spherical coordinates. It is possible to \n specify a section of the Earth. This subroutine is slower thatn PHGRPH. Arguments Type Intent Optional Attributes Name real :: CXMN real :: FELD (MAXL,MAXB,MLEVEL) real :: WSAVE integer :: IFAX (10) real :: Z (0:((MMAX+3)*(MMAX+4))/2,MAXB) integer :: MNAUF integer :: MMAX integer :: MAUF integer :: MANF integer :: MAXL integer :: MAXB integer :: MLEVEL Calls proc~~phgcut~~CallsGraph proc~phgcut PHGCUT proc~phsymcut PHSYMCUT proc~phgcut->proc~phsymcut proc~phgpns PHGPNS proc~phgcut->proc~phgpns proc~rfourtr RFOURTR proc~phsymcut->proc~rfourtr proc~phgpns->proc~rfourtr fft99 fft99 proc~rfourtr->fft99 Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Called by proc~~phgcut~~CalledByGraph proc~phgcut PHGCUT program~calc_etadot calc_etadot program~calc_etadot->proc~phgcut Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Contents None","tags":"","loc":"proc/phgcut.html","title":"PHGCUT – Flex_extract: Calculation of etadot"},{"text":"public subroutine PHSYMCUT(J, CXMN, FELD, Z, WSAVE, IFAX, MAUF, MNAUF, MAXL, MAXB, MLEVEL, MANF) Arguments Type Intent Optional Attributes Name integer :: J real :: CXMN real :: FELD (MAXL,MAXB,MLEVEL) real :: Z (0:((MNAUF+3)*(MNAUF+4))/2,MAXB) real :: WSAVE integer :: IFAX (10) integer :: MAUF integer :: MNAUF integer :: MAXL integer :: MAXB integer :: MLEVEL integer :: MANF Calls proc~~phsymcut~~CallsGraph proc~phsymcut PHSYMCUT proc~rfourtr RFOURTR proc~phsymcut->proc~rfourtr fft99 fft99 proc~rfourtr->fft99 Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Called by proc~~phsymcut~~CalledByGraph proc~phsymcut PHSYMCUT proc~phgcut PHGCUT proc~phgcut->proc~phsymcut program~calc_etadot calc_etadot program~calc_etadot->proc~phgcut Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Contents None","tags":"","loc":"proc/phsymcut.html","title":"PHSYMCUT – Flex_extract: Calculation of etadot"},{"text":"public subroutine PHGPNS(CXMN, FELD, Z, WSAVE, IFAX, J, MNAUF, MAUF, MANF, MAXL, MAXB, MLEVEL) Arguments Type Intent Optional Attributes Name real, intent(in) :: CXMN (0:(MNAUF+1)*(MNAUF+2)-1,MLEVEL) real :: FELD (MAXL,MAXB,MLEVEL) real, intent(in) :: Z (0:((MNAUF+3)*(MNAUF+4))/2,MAXB) real, intent(in) :: WSAVE (4*MAUF+15) integer :: IFAX (10) integer, intent(in) :: J integer, intent(in) :: MNAUF integer, intent(in) :: MAUF integer, intent(in) :: MANF integer, intent(in) :: MAXL integer, intent(in) :: MAXB integer, intent(in) :: MLEVEL Calls proc~~phgpns~~CallsGraph proc~phgpns PHGPNS proc~rfourtr RFOURTR proc~phgpns->proc~rfourtr fft99 fft99 proc~rfourtr->fft99 Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Called by proc~~phgpns~~CalledByGraph proc~phgpns PHGPNS proc~phgcut PHGCUT proc~phgcut->proc~phgpns program~calc_etadot calc_etadot program~calc_etadot->proc~phgcut Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Contents None","tags":"","loc":"proc/phgpns.html","title":"PHGPNS – Flex_extract: Calculation of etadot"},{"text":"public subroutine LEGTR(CXMN, CXM, Z, MNAUF, MAUF) Calculate the Fourier coefficients CXM Arguments Type Intent Optional Attributes Name real :: CXMN (0:(MNAUF+1)*(MNAUF+2)-1) real :: CXM (0:MAXAUF-1) real :: Z (0:((MNAUF+3)*(MNAUF+4))/2) integer :: MNAUF integer :: MAUF Contents None","tags":"","loc":"proc/legtr.html","title":"LEGTR – Flex_extract: Calculation of etadot"},{"text":"public subroutine RFOURTR(CXM, TRIGS, IFAX, MNAUF, MAXL, ISIGN) Calculates the Fourier sum with an FFT algorithm Arguments Type Intent Optional Attributes Name real :: CXM real :: TRIGS (2*MAXL) integer :: IFAX (10) integer :: MNAUF integer :: MAXL integer :: ISIGN Calls proc~~rfourtr~~CallsGraph proc~rfourtr RFOURTR fft99 fft99 proc~rfourtr->fft99 Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Called by proc~~rfourtr~~CalledByGraph proc~rfourtr RFOURTR proc~phsymcut PHSYMCUT proc~phsymcut->proc~rfourtr proc~phgpns PHGPNS proc~phgpns->proc~rfourtr proc~phgracut PHGRACUT proc~phgracut->proc~rfourtr proc~phgcut PHGCUT proc~phgcut->proc~phsymcut proc~phgcut->proc~phgpns program~calc_etadot calc_etadot program~calc_etadot->proc~phgcut Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Contents None","tags":"","loc":"proc/rfourtr.html","title":"RFOURTR – Flex_extract: Calculation of etadot"},{"text":"public subroutine GAULEG(X1, X2, X, W, N) Calculates the Gaussian latitudes Arguments Type Intent Optional Attributes Name real :: X1 real :: X2 real :: X real :: W integer :: N Calls proc~~gauleg~~CallsGraph proc~gauleg GAULEG dcos dcos proc~gauleg->dcos Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Called by proc~~gauleg~~CalledByGraph proc~gauleg GAULEG program~calc_etadot calc_etadot program~calc_etadot->proc~gauleg Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Contents None","tags":"","loc":"proc/gauleg.html","title":"GAULEG – Flex_extract: Calculation of etadot"},{"text":"public subroutine PLGNFA(LL, X, Z) Calculates all normalised associated Legendre functions from \n P00(X) to PLL(X) and writes them into the field Z.\n The polynomials have indices as with ECMWF, i.e.\n P00,P10,P11,P20,P21,P22,...\n Otherwise, this subroutine is analogous to PLGNDN Arguments Type Intent Optional Attributes Name integer :: LL real :: X real :: Z Contents None","tags":"","loc":"proc/plgnfa.html","title":"PLGNFA – Flex_extract: Calculation of etadot"},{"text":"public subroutine DPLGND(MNAUF, Z, DZ) Calculates the derivatives of the normalised associated Legendre function \n from P00(X) to PLL(X) and writes them into the field DZ.\n Order is P00(X),P01(X),P11(X),P02(X),P12(X),P22(X),..PLL(X) Arguments Type Intent Optional Attributes Name integer :: MNAUF real :: Z real :: DZ Contents None","tags":"","loc":"proc/dplgnd.html","title":"DPLGND – Flex_extract: Calculation of etadot"},{"text":"public subroutine SPFILTER(FELDMN, MM, MMAX) Implements spectral filter of Sardeshmukh and Hoskins (MWR 1984) Arguments Type Intent Optional Attributes Name real :: FELDMN (0:(MM+1)*(MM+2)-1) integer :: MM integer :: MMAX Calls proc~~spfilter~~CallsGraph proc~spfilter SPFILTER float float proc~spfilter->float alog alog proc~spfilter->alog Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Contents None","tags":"","loc":"proc/spfilter.html","title":"SPFILTER – Flex_extract: Calculation of etadot"},{"text":"public subroutine VDTOUV(XMN, XLAM, XPHI, GWSAVE, IFAX, P, MLAT, MNAUF, NI, NJ, NK) Uses PHTOGR proc~~vdtouv~~UsesGraph proc~vdtouv VDTOUV module~phtogr PHTOGR proc~vdtouv->module~phtogr Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Calculates scale winds from vorticity and divergence.\n If in XMN the divergence is passed, then the divergent part of the wind\n (XPHI=Ud,XPHI=Vd) is returned. If vorticity is passed, then the \n rotational part of the wind (XLAM=Vrot,XPHI=-Urot) is returned.\n Summing both, one obtains the whole scale wind. Arguments Type Intent Optional Attributes Name real :: XMN (0:(MNAUF+1)*(MNAUF+2)-1,NK) real :: XLAM (NI,NK) real :: XPHI (NI,NK) real :: GWSAVE (8*NJ+15,NJ/2) integer :: IFAX (10,NJ) real :: P (0:(MNAUF+3)*(MNAUF+4)/2,NJ/2) integer :: MLAT (NJ) integer :: MNAUF integer :: NI integer :: NJ integer :: NK Contents None","tags":"","loc":"proc/vdtouv.html","title":"VDTOUV – Flex_extract: Calculation of etadot"},{"text":"public subroutine VDUVSUB(J, XMN, XLAM, XPHI, GWSAVE, IFAX, P, GGIND, MLAT, MNAUF, NI, NJ, NK) Uses PHTOGR proc~~vduvsub~~UsesGraph proc~vduvsub VDUVSUB module~phtogr PHTOGR proc~vduvsub->module~phtogr Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Arguments Type Intent Optional Attributes Name integer :: J real :: XMN (0:(MNAUF+1)*(MNAUF+2)-1,NK) real :: XLAM (NI,NK) real :: XPHI (NI,NK) real :: GWSAVE (8*NJ+15,NJ/2) integer :: IFAX (10,NJ) real :: P (0:(MNAUF+3)*(MNAUF+4)/2,NJ/2) integer :: GGIND integer :: MLAT (NJ) integer :: MNAUF integer :: NI integer :: NJ integer :: NK Contents None","tags":"","loc":"proc/vduvsub.html","title":"VDUVSUB – Flex_extract: Calculation of etadot"},{"text":"public subroutine PHGRAD(XMN, XLAM, XPHI, GWSAVE, IFAX, P, H, MLAT, MNAUF, NI, NJ, NK) Uses PHTOGR proc~~phgrad~~UsesGraph proc~phgrad PHGRAD module~phtogr PHTOGR proc~phgrad->module~phtogr Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Calculates the gradient of a scalar from the field of the scalar XMN\n in phase space. Returns fields of the componentens of the horizontal\n gradients XLAM,XPHI on the Gaussian grid. Arguments Type Intent Optional Attributes Name real :: XMN (0:(MNAUF+1)*(MNAUF+2)-1,NK) real :: XLAM (NI,NK) real :: XPHI (NI,NK) real :: GWSAVE (8*NJ+15,NJ/2) integer :: IFAX (10,NJ) real :: P (0:(MNAUF+3)*(MNAUF+4)/2,NJ/2) real :: H (0:(MNAUF+2)*(MNAUF+3)/2) integer :: MLAT (NJ) integer :: MNAUF integer :: NI integer :: NJ integer :: NK Called by proc~~phgrad~~CalledByGraph proc~phgrad PHGRAD program~calc_etadot calc_etadot program~calc_etadot->proc~phgrad Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Contents None","tags":"","loc":"proc/phgrad.html","title":"PHGRAD – Flex_extract: Calculation of etadot"},{"text":"public subroutine PHGRACUT(XMN, XLAM, XPHI, GWSAVE, IFAX, P, H, MAUF, MNAUF, NI, NJ, MANF, NK) Uses PHTOGR proc~~phgracut~~UsesGraph proc~phgracut PHGRACUT module~phtogr PHTOGR proc~phgracut->module~phtogr Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Calculated the gradient of a scalar from the field of the scalar XMN \n in phase space. Returns the fields of the components of the horizontal\n gradient XLAM,XPHI on the Gaussian grid Arguments Type Intent Optional Attributes Name real :: XMN (0:(MNAUF+1)*(MNAUF+2)-1,NK) real :: XLAM (NI,NJ,NK) real :: XPHI (NI,NJ,NK) real :: GWSAVE (4*MAUF+15) integer :: IFAX (10) real :: P (0:(MNAUF+3)*(MNAUF+4)/2,NJ) real :: H (0:(MNAUF+2)*(MNAUF+3)/2) integer :: MAUF integer :: MNAUF integer :: NI integer :: NJ integer :: MANF integer :: NK Calls proc~~phgracut~~CallsGraph proc~phgracut PHGRACUT proc~rfourtr RFOURTR proc~phgracut->proc~rfourtr fft99 fft99 proc~rfourtr->fft99 Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Contents None","tags":"","loc":"proc/phgracut.html","title":"PHGRACUT – Flex_extract: Calculation of etadot"},{"text":"public subroutine CONTGL(PS, DPSDL, DPSDM, DIV, U, V, BREITE, ETA, MLAT, A, B, NI, NJ, NK) Calculation of divergence from the wind field (U,V)\n in phase space. Returns fields of the componentens of the \n horizontal gradients XLAM,XPHI on the Gaussian grid Arguments Type Intent Optional Attributes Name real :: PS (NI) real :: DPSDL (NI) real :: DPSDM (NI) real :: DIV (NI,NK) real :: U (NI,NK) real :: V (NI,NK) real :: BREITE (NJ) real :: ETA (NI,NK) integer :: MLAT (NJ) real :: A (NK+1) real :: B (NK+1) integer :: NI integer :: NJ integer :: NK Contents None","tags":"","loc":"proc/contgl.html","title":"CONTGL – Flex_extract: Calculation of etadot"},{"text":"public subroutine OMEGA(PS, DPSDL, DPSDM, DIV, U, V, BREITE, E, MLAT, A, B, NGI, NGJ, MKK) Calculates \\omega in the hybrid ( \\eta -)coordinate system Arguments Type Intent Optional Attributes Name real :: PS (NGI) real :: DPSDL (NGI) real :: DPSDM (NGI) real :: DIV (NGI,MKK) real :: U (NGI,MKK) real :: V (NGI,MKK) real :: BREITE (NGJ) real :: E (NGI,MKK) integer :: MLAT (NGJ) real :: A (MKK+1) real :: B (MKK+1) integer :: NGI integer :: NGJ integer :: MKK Contents None","tags":"","loc":"proc/omega.html","title":"OMEGA – Flex_extract: Calculation of etadot"},{"text":"Read or write a field variable on a lat/lon grid from/to GRIB file, or \n read a field in spectral representation from GRIB file Used by module~~rwgrib2~~UsedByGraph module~rwgrib2 RWGRIB2 program~calc_etadot calc_etadot program~calc_etadot->module~rwgrib2 Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Contents Subroutines READLATLON WRITELATLON READSPECTRAL Subroutines public subroutine READLATLON (filename, feld, maxl, maxb, mlevel, mpar) Read a field from GRIB file on lat-lon grid Arguments Type Intent Optional Attributes Name character(len=*) :: filename real, dimension(maxl,maxb,mlevel) :: feld integer :: maxl integer :: maxb integer :: mlevel integer :: mpar (:) public subroutine WRITELATLON (IUNIT, igrib, ogrib, FELD, MAXL, MAXB, MLEVEL, MLEVELIST, MSTRIDE, MPAR) write a field on lat-lon grid to GRIB file Arguments Type Intent Optional Attributes Name integer :: IUNIT integer :: igrib integer :: ogrib real :: FELD (MAXL,MAXB,MLEVEL) integer :: MAXL integer :: MAXB integer :: MLEVEL character(len=*) :: MLEVELIST integer :: MSTRIDE integer :: MPAR (MSTRIDE) public subroutine READSPECTRAL (filename, CXMN, mnauf, mlevel, maxlev, mpar, A, B) Read a GRIB file in spherical harmonics Arguments Type Intent Optional Attributes Name character(len=*) :: filename real :: CXMN (0:(MNAUF+1)*(MNAUF+2)-1,MLEVEL) integer :: mnauf integer :: mlevel integer :: maxlev integer :: mpar (:) real :: A (MAXLEV+1) real :: B (MAXLEV+1)","tags":"","loc":"module/rwgrib2.html","title":"RWGRIB2 – Flex_extract: Calculation of etadot"},{"text":"Module for transformation from phase space into physical space Uses PHTOGR module~~grtoph~~UsesGraph module~grtoph GRTOPH module~phtogr PHTOGR module~grtoph->module~phtogr Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Used by module~~grtoph~~UsedByGraph module~grtoph GRTOPH program~calc_etadot calc_etadot program~calc_etadot->module~grtoph Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Contents Subroutines GRPH213 GRPHSUB LGTR213 RFOUFTR Subroutines public subroutine GRPH213 (CXMN, FELD, WSAVE, IFAX, Z, W, MLAT, MNAUF, MAXL, MAXB, MLEVEL) Arguments Type Intent Optional Attributes Name real :: CXMN real :: FELD (MAXL,MLEVEL) real :: WSAVE integer :: IFAX (10,MAXB) real :: Z (MAXB/2,0:((MNAUF+3)*(MNAUF+4))/2) real :: W (MAXB) integer :: MLAT (MAXB) integer :: MNAUF integer :: MAXL integer :: MAXB integer :: MLEVEL public subroutine GRPHSUB (L, IND, CXMN, FELD, WSAVE, IFAX, Z, W, MLAT, MNAUF, MAXL, MAXB, MLEVEL) Carries out the transformation from the phase space into the physical\n space on spherical coordinates Arguments Type Intent Optional Attributes Name integer :: L integer :: IND (MAXB) real :: CXMN (0:(MNAUF+1)*(MNAUF+2)-1,MLEVEL) real :: FELD (MAXL,MLEVEL) real :: WSAVE (8*MAXB+15,MAXB/2) integer :: IFAX (10,MAXB) real :: Z (MAXB/2,0:((MNAUF+3)*(MNAUF+4))/2) real :: W (MAXB) integer :: MLAT (MAXB) integer :: MNAUF integer :: MAXL integer :: MAXB integer :: MLEVEL public subroutine LGTR213 (CXMN, CXM, Z, W, MLAT, MNAUF, MAXB) Calculates the KFFKs (Fourier coefficients) CXMN Arguments Type Intent Optional Attributes Name real :: CXMN real :: CXM real(kind=8) :: Z (MAXB/2,0:((MNAUF+3)*(MNAUF+4))/2) real(kind=8) :: W (MAXB) integer :: MLAT (MAXB) integer :: MNAUF integer :: MAXB public subroutine RFOUFTR (CXM, TRIGS, IFAX, MNAUF, MAXL, ISIGN) Calculates the Fourier sum with an FFT algorithm Arguments Type Intent Optional Attributes Name real :: CXM real :: TRIGS integer :: IFAX (10) integer :: MNAUF integer :: MAXL integer :: ISIGN","tags":"","loc":"module/grtoph.html","title":"GRTOPH – Flex_extract: Calculation of etadot"},{"text":"Module for transformation of a field variable from the phase space\n into the physical space onto the reduced Gaussian grid Used by module~~phtogr~~UsedByGraph module~phtogr PHTOGR proc~vduvsub VDUVSUB proc~vduvsub->module~phtogr program~calc_etadot calc_etadot program~calc_etadot->module~phtogr module~grtoph GRTOPH program~calc_etadot->module~grtoph proc~phgrad PHGRAD proc~phgrad->module~phtogr module~grtoph->module~phtogr proc~vdtouv VDTOUV proc~vdtouv->module~phtogr proc~phgracut PHGRACUT proc~phgracut->module~phtogr Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Contents Variables MAXAUF Subroutines PHGR213 PHSYM PHGCUT PHSYMCUT PHGPNS LEGTR RFOURTR GAULEG PLGNFA DPLGND SPFILTER Variables Type Visibility Attributes Name Initial integer, public, parameter :: MAXAUF = 36000 Subroutines public subroutine PHGR213 (CXMN, FELD, WSAVE, IFAX, Z, MLAT, MNAUF, MAXL, MAXB, MLEVEL) Arguments Type Intent Optional Attributes Name real :: CXMN (0:(MNAUF+1)*(MNAUF+2)-1,MLEVEL) real :: FELD (MAXL,MLEVEL) real :: WSAVE (8*MAXB+15,MAXB/2) integer :: IFAX (10,MAXB) real :: Z (0:((MNAUF+3)*(MNAUF+4))/2,MAXB/2) integer :: MLAT (MAXB/2) integer :: MNAUF integer :: MAXL integer :: MAXB integer :: MLEVEL public subroutine PHSYM (K, IND, CXMN, FELD, Z, WSAVE, IFAX, MLAT, MNAUF, MAXL, MAXB, MLEVEL) Arguments Type Intent Optional Attributes Name integer :: K integer :: IND (MAXB) real :: CXMN (0:(MNAUF+1)*(MNAUF+2)-1,MLEVEL) real :: FELD (MAXL,MLEVEL) real :: Z (0:((MNAUF+3)*(MNAUF+4))/2,MAXB/2) real :: WSAVE (8*MAXB+15,MAXB/2) integer :: IFAX (10,MAXB) integer :: MLAT (MAXB/2) integer :: MNAUF integer :: MAXL integer :: MAXB integer :: MLEVEL public subroutine PHGCUT (CXMN, FELD, WSAVE, IFAX, Z, MNAUF, MMAX, MAUF, MANF, MAXL, MAXB, MLEVEL) Carries out the transformation of a field variable from the phase space\n into the physical space on spherical coordinates. It is possible to \n specify a section of the Earth. This subroutine is slower thatn PHGRPH. Arguments Type Intent Optional Attributes Name real :: CXMN real :: FELD (MAXL,MAXB,MLEVEL) real :: WSAVE integer :: IFAX (10) real :: Z (0:((MMAX+3)*(MMAX+4))/2,MAXB) integer :: MNAUF integer :: MMAX integer :: MAUF integer :: MANF integer :: MAXL integer :: MAXB integer :: MLEVEL public subroutine PHSYMCUT (J, CXMN, FELD, Z, WSAVE, IFAX, MAUF, MNAUF, MAXL, MAXB, MLEVEL, MANF) Arguments Type Intent Optional Attributes Name integer :: J real :: CXMN real :: FELD (MAXL,MAXB,MLEVEL) real :: Z (0:((MNAUF+3)*(MNAUF+4))/2,MAXB) real :: WSAVE integer :: IFAX (10) integer :: MAUF integer :: MNAUF integer :: MAXL integer :: MAXB integer :: MLEVEL integer :: MANF public subroutine PHGPNS (CXMN, FELD, Z, WSAVE, IFAX, J, MNAUF, MAUF, MANF, MAXL, MAXB, MLEVEL) Arguments Type Intent Optional Attributes Name real, intent(in) :: CXMN (0:(MNAUF+1)*(MNAUF+2)-1,MLEVEL) real :: FELD (MAXL,MAXB,MLEVEL) real, intent(in) :: Z (0:((MNAUF+3)*(MNAUF+4))/2,MAXB) real, intent(in) :: WSAVE (4*MAUF+15) integer :: IFAX (10) integer, intent(in) :: J integer, intent(in) :: MNAUF integer, intent(in) :: MAUF integer, intent(in) :: MANF integer, intent(in) :: MAXL integer, intent(in) :: MAXB integer, intent(in) :: MLEVEL public subroutine LEGTR (CXMN, CXM, Z, MNAUF, MAUF) Calculate the Fourier coefficients CXM Arguments Type Intent Optional Attributes Name real :: CXMN (0:(MNAUF+1)*(MNAUF+2)-1) real :: CXM (0:MAXAUF-1) real :: Z (0:((MNAUF+3)*(MNAUF+4))/2) integer :: MNAUF integer :: MAUF public subroutine RFOURTR (CXM, TRIGS, IFAX, MNAUF, MAXL, ISIGN) Calculates the Fourier sum with an FFT algorithm Arguments Type Intent Optional Attributes Name real :: CXM real :: TRIGS (2*MAXL) integer :: IFAX (10) integer :: MNAUF integer :: MAXL integer :: ISIGN public subroutine GAULEG (X1, X2, X, W, N) Calculates the Gaussian latitudes Arguments Type Intent Optional Attributes Name real :: X1 real :: X2 real :: X real :: W integer :: N public subroutine PLGNFA (LL, X, Z) Calculates all normalised associated Legendre functions from \n P00(X) to PLL(X) and writes them into the field Z.\n The polynomials have indices as with ECMWF, i.e.\n P00,P10,P11,P20,P21,P22,...\n Otherwise, this subroutine is analogous to PLGNDN Arguments Type Intent Optional Attributes Name integer :: LL real :: X real :: Z public subroutine DPLGND (MNAUF, Z, DZ) Calculates the derivatives of the normalised associated Legendre function \n from P00(X) to PLL(X) and writes them into the field DZ.\n Order is P00(X),P01(X),P11(X),P02(X),P12(X),P22(X),..PLL(X) Arguments Type Intent Optional Attributes Name integer :: MNAUF real :: Z real :: DZ public subroutine SPFILTER (FELDMN, MM, MMAX) Implements spectral filter of Sardeshmukh and Hoskins (MWR 1984) Arguments Type Intent Optional Attributes Name real :: FELDMN (0:(MM+1)*(MM+2)-1) integer :: MM integer :: MMAX","tags":"","loc":"module/phtogr.html","title":"PHTOGR – Flex_extract: Calculation of etadot"},{"text":"Implementation of the spectral transformation using the reduced Gaussian grid Used by module~~ftrafo~~UsedByGraph module~ftrafo FTRAFO program~calc_etadot calc_etadot program~calc_etadot->module~ftrafo Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Contents Subroutines VDTOUV VDUVSUB PHGRAD PHGRACUT CONTGL OMEGA Subroutines public subroutine VDTOUV (XMN, XLAM, XPHI, GWSAVE, IFAX, P, MLAT, MNAUF, NI, NJ, NK) Calculates scale winds from vorticity and divergence.\n If in XMN the divergence is passed, then the divergent part of the wind\n (XPHI=Ud,XPHI=Vd) is returned. If vorticity is passed, then the \n rotational part of the wind (XLAM=Vrot,XPHI=-Urot) is returned.\n Summing both, one obtains the whole scale wind. Arguments Type Intent Optional Attributes Name real :: XMN (0:(MNAUF+1)*(MNAUF+2)-1,NK) real :: XLAM (NI,NK) real :: XPHI (NI,NK) real :: GWSAVE (8*NJ+15,NJ/2) integer :: IFAX (10,NJ) real :: P (0:(MNAUF+3)*(MNAUF+4)/2,NJ/2) integer :: MLAT (NJ) integer :: MNAUF integer :: NI integer :: NJ integer :: NK public subroutine VDUVSUB (J, XMN, XLAM, XPHI, GWSAVE, IFAX, P, GGIND, MLAT, MNAUF, NI, NJ, NK) Arguments Type Intent Optional Attributes Name integer :: J real :: XMN (0:(MNAUF+1)*(MNAUF+2)-1,NK) real :: XLAM (NI,NK) real :: XPHI (NI,NK) real :: GWSAVE (8*NJ+15,NJ/2) integer :: IFAX (10,NJ) real :: P (0:(MNAUF+3)*(MNAUF+4)/2,NJ/2) integer :: GGIND integer :: MLAT (NJ) integer :: MNAUF integer :: NI integer :: NJ integer :: NK public subroutine PHGRAD (XMN, XLAM, XPHI, GWSAVE, IFAX, P, H, MLAT, MNAUF, NI, NJ, NK) Calculates the gradient of a scalar from the field of the scalar XMN\n in phase space. Returns fields of the componentens of the horizontal\n gradients XLAM,XPHI on the Gaussian grid. Arguments Type Intent Optional Attributes Name real :: XMN (0:(MNAUF+1)*(MNAUF+2)-1,NK) real :: XLAM (NI,NK) real :: XPHI (NI,NK) real :: GWSAVE (8*NJ+15,NJ/2) integer :: IFAX (10,NJ) real :: P (0:(MNAUF+3)*(MNAUF+4)/2,NJ/2) real :: H (0:(MNAUF+2)*(MNAUF+3)/2) integer :: MLAT (NJ) integer :: MNAUF integer :: NI integer :: NJ integer :: NK public subroutine PHGRACUT (XMN, XLAM, XPHI, GWSAVE, IFAX, P, H, MAUF, MNAUF, NI, NJ, MANF, NK) Calculated the gradient of a scalar from the field of the scalar XMN \n in phase space. Returns the fields of the components of the horizontal\n gradient XLAM,XPHI on the Gaussian grid Arguments Type Intent Optional Attributes Name real :: XMN (0:(MNAUF+1)*(MNAUF+2)-1,NK) real :: XLAM (NI,NJ,NK) real :: XPHI (NI,NJ,NK) real :: GWSAVE (4*MAUF+15) integer :: IFAX (10) real :: P (0:(MNAUF+3)*(MNAUF+4)/2,NJ) real :: H (0:(MNAUF+2)*(MNAUF+3)/2) integer :: MAUF integer :: MNAUF integer :: NI integer :: NJ integer :: MANF integer :: NK public subroutine CONTGL (PS, DPSDL, DPSDM, DIV, U, V, BREITE, ETA, MLAT, A, B, NI, NJ, NK) Calculation of divergence from the wind field (U,V)\n in phase space. Returns fields of the componentens of the \n horizontal gradients XLAM,XPHI on the Gaussian grid Arguments Type Intent Optional Attributes Name real :: PS (NI) real :: DPSDL (NI) real :: DPSDM (NI) real :: DIV (NI,NK) real :: U (NI,NK) real :: V (NI,NK) real :: BREITE (NJ) real :: ETA (NI,NK) integer :: MLAT (NJ) real :: A (NK+1) real :: B (NK+1) integer :: NI integer :: NJ integer :: NK public subroutine OMEGA (PS, DPSDL, DPSDM, DIV, U, V, BREITE, E, MLAT, A, B, NGI, NGJ, MKK) Calculates \\omega in the hybrid ( \\eta -)coordinate system Arguments Type Intent Optional Attributes Name real :: PS (NGI) real :: DPSDL (NGI) real :: DPSDM (NGI) real :: DIV (NGI,MKK) real :: U (NGI,MKK) real :: V (NGI,MKK) real :: BREITE (NGJ) real :: E (NGI,MKK) integer :: MLAT (NGJ) real :: A (MKK+1) real :: B (MKK+1) integer :: NGI integer :: NGJ integer :: MKK","tags":"","loc":"module/ftrafo.html","title":"FTRAFO – Flex_extract: Calculation of etadot"},{"text":"Uses PHTOGR GRTOPH FTRAFO RWGRIB2 GRIB_API program~~calc_etadot~~UsesGraph program~calc_etadot calc_etadot module~phtogr PHTOGR program~calc_etadot->module~phtogr module~rwgrib2 RWGRIB2 program~calc_etadot->module~rwgrib2 module~ftrafo FTRAFO program~calc_etadot->module~ftrafo module~grtoph GRTOPH program~calc_etadot->module~grtoph GRIB_API GRIB_API program~calc_etadot->GRIB_API module~grtoph->module~phtogr Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Prepare input data for FLEXPART, esp. vertical velocity as \n etadot or etadot * dp/deta author: L. Haimberger\n date:   03/2010\n version: V4.0 Program calc_etadot Prepares input data for POP model meteorological preprocessor Calculation of etapoint on a regular \\lambda-\\phi grid and writing U,V,ETAPOINT,T,PS,Q,SD,MSL,TCC,10U, 10V, 2T,2D,LSP,CP,SSHF,SSR, \n EWSS,NSSS to an output file (input and output in GRIB 1 or 2 format). etapoint is defined as the total time derivative of \n  ECMWF vertical coordinate eta multiplied by the derivative\n  of pressure with respect to eta: \\frac{\\mathrm{d}\\eta}{\\mathrm{d}t}\\frac{\\partial p}{\\partial \\eta} Version history and authors: 04/1994: Leopold Haimberger, Gerhard Wotawa 2003-05-11: Alexander Beck 12/2006: L. Haimberger V2.0,\n           handle arbitrary regular grids and T799 resolution data 03/2010: L. Haimberger V4.0,\n           handle GRIB edition 2 fields and T1279 resolution data 04-06/2019: Petra Seibert, \n            beautify code and add FORD documentation 06/2020: Petra Seibert, translate some comments into English\n            comment out writing of VERTICAL.EC Input required: UNIT  FILE      PARAMETER(S)    DATA REPRESENTATION\n\n 11    fort.11   T,U,V           regular lat-lon grid\n 12    fort.12   D               regular lat-lon grid   \n 13    fort.13   LNSP            spherical harmonics\n 14    fort.14   SD,MSL,TCC,10U,                                \n                 10V,2T,2D       regular lat-lon grid     \n 16    fort.16   LSP,CP,SSHF,         \n                 SSR,EWSS,NSSS   regular lat-lon grid\n 17    fort.17   Q               regular lat-lon grid Output produced: UNIT  FILE      PARAMETER(S)      DATA REPRESENTATION\n\n15    fort.15   `U,V,ETA,T,PS,                                  \n                `Q,SD,MSL,TCC,`                                  \n                `10U,10V,2T,2D,`  regular lat-lon grid         \n                `LSP,CP,SSHF,`                                   \n                `SSR,EWSS,NSSS` ALLOCATE VARIABLES Initialise  Legendre transformation on the lat-lon grid Initialisation of fields for FFT and Legendre transformation\n to Gaussian grid and back to phase space\n  read LNSP in SH\n  read u,v in SH\n  Transforming the wind to the Gaussian grid\n  read DIV in SH\n Transform horizontal divergence to the Gaussian grid\n Calculation of the gradient of LNSP (log of surface pressure) on Gaussian grid Calculation of the vertical velocity on the Gaussian grid Calculation of omega on the Gaussian grid READING OF SURFACE PRESSURE READING OF U,V READING OF LNSP on grid READING OF DIVERGENCE Initialise Legendre transformation on the lat-lon grid.\n Without Gaussian grid calculation, \n Legendre polynomials are calculated only for one latitude, to save space READING OF T READING OF SPECIFIC HUMIDITY WRITE MODEL LEVEL DATA TO fort.15 Calls program~~calc_etadot~~CallsGraph program~calc_etadot calc_etadot proc~readspectral READSPECTRAL program~calc_etadot->proc~readspectral proc~phgcut PHGCUT program~calc_etadot->proc~phgcut proc~grph213 GRPH213 program~calc_etadot->proc~grph213 grib_close_file grib_close_file program~calc_etadot->grib_close_file proc~statis STATIS program~calc_etadot->proc~statis proc~phgr213 PHGR213 program~calc_etadot->proc~phgr213 proc~gauleg GAULEG program~calc_etadot->proc~gauleg grib_open_file grib_open_file program~calc_etadot->grib_open_file set99 set99 program~calc_etadot->set99 proc~posnam POSNAM program~calc_etadot->proc~posnam proc~readlatlon READLATLON program~calc_etadot->proc~readlatlon proc~phgrad PHGRAD program~calc_etadot->proc~phgrad proc~readspectral->grib_close_file grib_count_in_file grib_count_in_file proc~readspectral->grib_count_in_file proc~phsymcut PHSYMCUT proc~phgcut->proc~phsymcut proc~phgpns PHGPNS proc~phgcut->proc~phgpns proc~grphsub GRPHSUB proc~grph213->proc~grphsub ind ind proc~grph213->ind proc~phsym PHSYM proc~phgr213->proc~phsym dcos dcos proc~gauleg->dcos proc~readlatlon->grib_close_file proc~readlatlon->grib_count_in_file proc~rfourtr RFOURTR proc~phsymcut->proc~rfourtr proc~phgpns->proc~rfourtr fft99 fft99 proc~rfourtr->fft99 Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Contents Variables LNPS Z T UV UV2 QA OM OMR DIV ETA ETAR DPSDL DPSDM PS DPSDT SURF FLUX OROLSM WSAVE H SINL COSL WSAVE2 BREITE GBREITE AK BK pv X1 X2 RMS MW SIG LAM CUA CVA P PP P2 XMN HILFUV LNPMN LNPMN2 LNPMN3 WEIGHT UGVG DG ETAG GWSAVE PSG HILF MLAT MPSURF MPFLUX MPORO MPAR GIFAX PI COSB DAK DBK P00 URLAR8 JMIN1 LLLAR8 MAXBMIN1 PIR8 DCOSB I J K L IERR M LTEST MK NGI NGJ MFLUX MSURF MORO LUNIT LUNIT2 MAXL MAXB MLEVEL LEVOUT LEVMIN LEVMAX MOMEGA MOMEGADIFF MGAUSS MSMOOTH MNAUF META METADIFF MDPDETA METAPAR RLO0 RLO1 RLA0 RLA1 MLEVELIST MAUF MANF IFAX IGRIB iret ogrib FILENAME Variables Type Attributes Name Initial real, ALLOCATABLE, DIMENSION (:,:) :: LNPS real, ALLOCATABLE, DIMENSION (:,:) :: Z real, ALLOCATABLE, DIMENSION (:,:,:) :: T real, ALLOCATABLE, DIMENSION (:,:,:) :: UV real, ALLOCATABLE, DIMENSION (:,:,:) :: UV2 real, ALLOCATABLE, DIMENSION (:,:,:) :: QA real, ALLOCATABLE, DIMENSION (:,:,:) :: OM real, ALLOCATABLE, DIMENSION (:,:,:) :: OMR real, ALLOCATABLE, DIMENSION (:,:,:) :: DIV real, ALLOCATABLE, DIMENSION (:,:,:) :: ETA real, ALLOCATABLE, DIMENSION (:,:,:) :: ETAR real, ALLOCATABLE, DIMENSION (:,:) :: DPSDL real, ALLOCATABLE, DIMENSION (:,:) :: DPSDM real, ALLOCATABLE, DIMENSION (:,:,:) :: PS real, ALLOCATABLE, DIMENSION (:,:,:) :: DPSDT real, ALLOCATABLE, DIMENSION (:,:,:) :: SURF real, ALLOCATABLE, DIMENSION (:,:,:) :: FLUX real, ALLOCATABLE, DIMENSION (:,:,:) :: OROLSM real, ALLOCATABLE, DIMENSION (:) :: WSAVE real, ALLOCATABLE, DIMENSION (:) :: H real, ALLOCATABLE, DIMENSION (:) :: SINL real, ALLOCATABLE, DIMENSION (:) :: COSL real, ALLOCATABLE, DIMENSION (:) :: WSAVE2 real, ALLOCATABLE, DIMENSION (:) :: BREITE real, ALLOCATABLE, DIMENSION (:) :: GBREITE real, ALLOCATABLE, DIMENSION (:) :: AK real, ALLOCATABLE, DIMENSION (:) :: BK real, ALLOCATABLE, DIMENSION (:) :: pv real :: X1 real :: X2 real :: RMS real :: MW real :: SIG real :: LAM real, ALLOCATABLE :: CUA (:,:,:) real, ALLOCATABLE :: CVA (:,:,:) real, ALLOCATABLE, DIMENSION (:,:) :: P real, ALLOCATABLE, DIMENSION (:,:) :: PP real, ALLOCATABLE, DIMENSION (:,:) :: P2 real, ALLOCATABLE, DIMENSION (:,:) :: XMN real, ALLOCATABLE, DIMENSION (:,:) :: HILFUV real, ALLOCATABLE, DIMENSION (:) :: LNPMN real, ALLOCATABLE, DIMENSION (:) :: LNPMN2 real, ALLOCATABLE, DIMENSION (:) :: LNPMN3 real, ALLOCATABLE, DIMENSION (:) :: WEIGHT real, ALLOCATABLE, DIMENSION (:,:) :: UGVG real, ALLOCATABLE, DIMENSION (:,:) :: DG real, ALLOCATABLE, DIMENSION (:,:) :: ETAG real, ALLOCATABLE, DIMENSION (:,:) :: GWSAVE real, ALLOCATABLE, DIMENSION (:) :: PSG real, ALLOCATABLE, DIMENSION (:) :: HILF integer, ALLOCATABLE, DIMENSION (:) :: MLAT integer, ALLOCATABLE, DIMENSION (:) :: MPSURF integer, ALLOCATABLE, DIMENSION (:) :: MPFLUX integer, ALLOCATABLE, DIMENSION (:) :: MPORO integer, ALLOCATABLE, DIMENSION (:) :: MPAR integer, ALLOCATABLE :: GIFAX (:,:) real :: PI real :: COSB real :: DAK real :: DBK real :: P00 real :: URLAR8 real :: JMIN1 real :: LLLAR8 real :: MAXBMIN1 real :: PIR8 real :: DCOSB integer :: I integer :: J integer :: K integer :: L integer :: IERR integer :: M integer :: LTEST integer :: MK integer :: NGI integer :: NGJ integer :: MFLUX integer :: MSURF integer :: MORO integer :: LUNIT integer :: LUNIT2 integer :: MAXL integer :: MAXB integer :: MLEVEL integer :: LEVOUT integer :: LEVMIN integer :: LEVMAX integer :: MOMEGA integer :: MOMEGADIFF integer :: MGAUSS integer :: MSMOOTH integer :: MNAUF integer :: META integer :: METADIFF integer :: MDPDETA integer :: METAPAR real :: RLO0 real :: RLO1 real :: RLA0 real :: RLA1 character(len=300) :: MLEVELIST integer :: MAUF integer :: MANF integer :: IFAX (10) integer :: IGRIB (1) integer :: iret integer :: ogrib character(len=80) :: FILENAME","tags":"","loc":"program/calc_etadot.html","title":"calc_etadot – Flex_extract: Calculation of etadot"}]}