# -*- coding: utf-8 -*-
#
# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# http://www.sphinx-doc.org/en/master/config

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys, glob
sys.path.insert(0, os.path.abspath('../../../Source/Python'))
sys.path.insert(0, os.path.abspath('../../../Source/Python/Mods'))
sys.path.insert(0, os.path.abspath('../../../Source/Python/Classes'))

sys.path.insert(0, os.path.abspath('_static/python'))
sys.setrecursionlimit(1500)

#fortran_src = [f for f in os.listdir('../../../source/fortran') if '.f90' in f or '.f' in f]
#print(fortran_src)

# -- Project information -----------------------------------------------------

project = u'flex_extract'
copyright = u'2020, Anne Philipp, Leopold Haimberger and Petra Seibert'
author = u'Anne Philipp, Leopold Haimberger and Petra Seibert'

# The short X.Y version
version = u'7.1.2'
# The full version, including alpha/beta/rc tags
release = u'7.1.2'


# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.napoleon',
    'sphinx.ext.autodoc',
    'sphinx.ext.autosectionlabel',
    'sphinx.ext.todo',
    'sphinx.ext.coverage',
    'sphinx.ext.mathjax',
    'sphinx.ext.ifconfig',
    'sphinx.ext.viewcode',
    'sphinx.ext.githubpages',
    'sphinx-jsonschema',
    'sphinx.ext.intersphinx',
    'hidden_code_block',
    'sphinxcontrib.exceltable',
    'sphinxcontrib.seqdiag',
    'sphinxcontrib.blockdiag',
    'sphinx.ext.todo',
#    'sphinxfortran.fortran_autodoc',
#    'sphinxfortran.fortran_domain'
]


# Fontpath for seqdiag (truetype font)
seqdiag_fontpath = '/usr/share/fonts/dejavu/DejaVuSerif.ttf'

# Fontpath for blockdiag (truetype font)
blockdiag_fontpath = '/usr/share/fonts/dejavu/DejaVuSerif.ttf'


# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = ['.rst', '.md', '.txt']

# The master toctree document.
master_doc = 'index'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path .
exclude_patterns = []

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'sphinx_rtd_theme'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
html_theme_options = {
     'display_version': True,
     'titles_only': False,
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.
#
# html_sidebars = {}


# -- Options for HTMLHelp output ---------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'flex_extractdoc'


# -- Options for LaTeX output ------------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    'papersize': 'a4paper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    'pointsize': '12pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'flex_extract.tex', u'flex\\_extract Documentation',
     u'Anne Philipp and Leopold Haimberger', 'manual'),
]


# -- Options for manual page output ------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'flex_extract', u'flex_extract Documentation',
     [author], 1)
]


# -- Options for Texinfo output ----------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'flex_extract', u'flex_extract Documentation',
     author, 'flex_extract', 'One line description of project.',
     'Miscellaneous'),
]


# -- Extension configuration -------------------------------------------------

html_context = {
    'css_files': ['_static/css/custom.css',
                  '_static/css/theme_overrides.css'
                 ],
}

# -- Options for todo extension ----------------------------------------------

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True
#todo_link_only = True


# -- Add extra css -----------------------------------------------------------
def setup(app):
    app.add_stylesheet('css/custom.css')



